/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.util;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.StringTokenizer;

public final class Log {
    public static final short LEVEL_EMERGENCY = 0;
    public static final short LEVEL_ALERT = 1;
    public static final short LEVEL_CRITICAL = 2;
    public static final short LEVEL_ERROR = 3;
    public static final short LEVEL_WARNING = 4;
    public static final short LEVEL_NOTICE = 5;
    public static final short LEVEL_INFO = 6;
    public static final short LEVEL_DEBUG = 7;
    public static boolean DEBUG = false;
    private static Writer _errorWriter;
    private static Writer _outputWriter;
    private static String _facility;
    private static short _outputLevel;
    private static short _errorLevel;
    private static short _stackTraceLevel;
    private static boolean _printTime;
    private static boolean _printPrevException;

    static {
        _facility = "OpenXML";
        _outputLevel = (short)7;
        _errorLevel = (short)2;
        _stackTraceLevel = (short)7;
        _printTime = false;
        _printPrevException = true;
        _errorWriter = new OutputStreamWriter(System.err);
        _outputWriter = new OutputStreamWriter(System.out);
    }

    public static void debug(String string) {
        Log.print((short)7, _facility, string);
    }

    public static void debug(Throwable throwable) {
        Log.print((short)7, _facility, throwable);
    }

    public static void error(String string) {
        Log.print((short)3, _facility, string);
    }

    public static void error(Throwable throwable) {
        Log.print((short)3, _facility, throwable);
    }

    public static void info(String string) {
        Log.print((short)6, _facility, string);
    }

    public static void info(Throwable throwable) {
        Log.print((short)6, _facility, throwable);
    }

    private static String levelAsString(short s) {
        switch (s) {
            case 0: {
                return "EMERGENCY";
            }
            case 1: {
                return "ALERT";
            }
            case 2: {
                return "CRITICAL";
            }
            case 3: {
                return "error";
            }
            case 4: {
                return "warning";
            }
            case 5: {
                return "notice";
            }
            case 6: {
                return "info";
            }
            case 7: {
                return "debug";
            }
        }
        if (s < 0) {
            return "EMERGENCY";
        }
        return "debug" + (s - 7 + 1);
    }

    public static void print(short s, String string) {
        Log.print(s, _facility, string);
    }

    public static void print(short s, String string, String string2) {
        if (s <= _outputLevel || s <= _errorLevel) {
            StringBuffer stringBuffer = new StringBuffer(80);
            if (_printTime) {
                stringBuffer.append('[').append(new Date().toString()).append("] ");
            }
            stringBuffer.append('[').append(Log.levelAsString(s)).append("] ");
            if (string != null && !string.equals(_facility)) {
                stringBuffer.append('[').append(string).append("] ");
            }
            int n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if (c >= ' ' && c < '\u007f' || c == '\t') {
                    stringBuffer.append(c);
                } else if (c < '\u0010') {
                    stringBuffer.append("#0").append(Integer.toHexString(c));
                } else {
                    stringBuffer.append('#').append(Integer.toHexString(c));
                }
                ++n;
            }
            Log.writeLine(s, stringBuffer);
        }
    }

    public static void print(short s, String string, Throwable throwable) {
        if (s <= _outputLevel || s <= _errorLevel) {
            Log.print(s, string, "Exception " + throwable.getClass().getName() + ": " + throwable.getMessage());
            if (s <= _stackTraceLevel) {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                StringTokenizer stringTokenizer = new StringTokenizer(stringWriter.toString(), "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    Log.print(s, string, stringTokenizer.nextToken());
                }
            }
        }
    }

    public static void print(short s, Throwable throwable) {
        Log.print(s, _facility, throwable);
    }

    private static void writeLine(short s, StringBuffer stringBuffer) {
        try {
            if (s <= _outputLevel) {
                _outputWriter.write(stringBuffer.toString());
                _outputWriter.write(10);
                _outputWriter.flush();
            }
        }
        catch (IOException iOException) {}
        try {
            if (s <= _errorLevel) {
                _errorWriter.write(stringBuffer.toString());
                _errorWriter.write(10);
                _outputWriter.flush();
            }
        }
        catch (IOException iOException) {}
    }
}

