/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p.processors;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.openxml.util.Log;
import org.openxml.util.Resources;
import org.openxml.x3p.ProcessContext;
import org.openxml.x3p.Processor;
import org.openxml.x3p.ProcessorEngine;
import org.openxml.x3p.ProcessorEngineCreator;
import org.openxml.x3p.ProcessorException;
import org.openxml.x3p.processors.ProcessContextImpl;
import org.openxml.x3p.processors.TreeIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PIProcessor
extends ProcessContextImpl
implements Processor,
ProcessorEngine {
    private Hashtable _engines;
    private Dictionary _factories;

    public PIProcessor(Object object, Dictionary dictionary) {
        super(object);
        if (dictionary == null) {
            throw new NullPointerException(Resources.format("Error001", "factories"));
        }
        this._factories = dictionary;
    }

    protected ProcessorEngine createEngine(ProcessContext processContext, String string) {
        ProcessorEngine processorEngine;
        if (this._engines != null && (processorEngine = (ProcessorEngine)this._engines.get(string)) != null) {
            return processorEngine;
        }
        ProcessorEngineCreator processorEngineCreator = (ProcessorEngineCreator)this._factories.get(string);
        if (processorEngineCreator == null) {
            return null;
        }
        processorEngine = processorEngineCreator.createEngine(processContext);
        if ((processorEngine.whatToProcess() & 0x80) == 0) {
            return null;
        }
        if (this._engines == null) {
            this._engines = new Hashtable();
        }
        this._engines.put(string, processorEngine);
        return processorEngine;
    }

    public void destroy(ProcessContext processContext) {
    }

    public ProcessContext getContext() {
        return this;
    }

    public synchronized Node process(ProcessContext processContext, Node node) throws ProcessorException {
        Node node2;
        ProcessorEngine processorEngine;
        while (node.getNodeType() == 7) {
            processorEngine = this.createEngine(processContext, node.getNodeName());
            if (processorEngine == null) {
                return node;
            }
            if (Log.DEBUG) {
                Log.debug("PIProcessor.process: Created processor engine [" + processorEngine + "]");
            }
            node2 = processorEngine.process(processContext, node);
            processorEngine.destroy(processContext);
            if (node2 == null) {
                return null;
            }
            if (node2 == node) {
                return node;
            }
            node = node2;
        }
        TreeIterator treeIterator = new TreeIterator(node, 128);
        Node node3 = treeIterator.nextNode();
        while (node3 != null) {
            Node node4 = treeIterator.nextNode();
            processorEngine = this.createEngine(processContext, node3.getNodeName());
            if (processorEngine != null) {
                if (Log.DEBUG) {
                    Log.debug("PIProcessor.process: Created processor engine [" + processorEngine + "]");
                }
                if ((node2 = processorEngine.process(processContext, node3)) == null) {
                    node3.getParentNode().removeChild(node3);
                } else if (node2 != node3) {
                    node3.getParentNode().replaceChild(node2, node3);
                }
            }
            node3 = node4;
        }
        if (this._engines != null) {
            Enumeration enumeration = this._engines.elements();
            while (enumeration.hasMoreElements()) {
                ((ProcessorEngine)enumeration.nextElement()).destroy(processContext);
            }
            this._engines = null;
        }
        return node;
    }

    public synchronized Document process(Document document) throws ProcessorException {
        return (Document)this.process(this.getContext(), document);
    }

    public synchronized Node process(Node node) throws ProcessorException {
        return this.process(this.getContext(), node);
    }

    public String toString() {
        Enumeration enumeration = this._factories.keys();
        if (!enumeration.hasMoreElements()) {
            return Resources.message("Processor002");
        }
        String string = (String)enumeration.nextElement();
        String string2 = "PIProcessor [" + string + ":" + this._factories.get(string).toString();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = String.valueOf(string2) + ", " + string + ":" + this._factories.get(string).toString();
        }
        return String.valueOf(string2) + "]";
    }

    public int whatToProcess() {
        return 128;
    }
}

