# $Header: /CVSROOT/yahoo/audit/rt/stats/support.pm,v 1.6 1998/09/09 21:54:47 serge Exp $
# support functions for stats module

package rt::stats;
require rt::stats::db::db;

use strict; 

sub get_db_stats
{
my ($users,$tbl,$q,$datef,$datet) = @_;
my $i;
my @dt;
my $msg;

   for( keys %$users )
   {
	$$tbl{$_}{real_name} = $$users{$_};
   }

   $msg = &get_unumbers($tbl,$q,$datef,$datet);
   return '';
}

sub get_users
{
my ($users,$q,$qs) = @_;
my $qquery = 'SELECT display,manipulate,admin,user_id FROM queue_acl';
my $qwhere = ' WHERE queue_id IN (';
my $uquery = 'SELECT user_id,real_name FROM users';
my $uwhere = ' WHERE user_id IN (';
my $query;
my $msg;
my @dt;
my $i;
my @us;
my @qqs;

   $query = $qquery;
   if( $q )
   {
	push @qqs, &db::db_quote($q);
   }
   else
   {
   	for( @$qs )
   	{
   		push @qqs, &db::db_quote($_);
   	}
   }
   $query .= $qwhere . join(",",@qqs) . ')';
   $msg = &db::db_fetch($query,\@dt);
   return $msg if $msg;
   return '' if $#dt < 0;
   for( $i = 0; $i <= $#dt; $i++ )
   {
   	$$users{$dt[$i]{user_id}} = 1 if $dt[$i]{display} || $dt[$i]{manipulate} || $dt[$i]{admin};
   }

   for( keys %$users )
   {
   	push @us, &db::db_quote($_);
   }
   $query = $uquery . $uwhere . join(",",@us) . ')';
   undef @dt;
   $msg = &db::db_fetch($query,\@dt);
   return $msg if $msg;
   for( $i = 0; $i <= $#dt; $i++ )
   {
   	$$users{$dt[$i]{user_id}} = $dt[$i]{real_name};
   }
   $$users{nobody} = 'Unassigned tickets';
   return '';
}

sub get_unumbers
{
my ($tbl,$q,$datef,$datet) = @_;
my $squery = 'SELECT count(date_created) FROM each_req WHERE owner=';
my $adds = '';
my $query;
my $msg;
my @dt;
my $i;
my @status = ('open','stalled','resolved');
my $st;
my $owner;

   $adds = ' AND queue_id=' . &db::db_quote($q) if $q;
   $adds .= " AND date_created BETWEEN $datef AND $datet" if $datef && $datet;
   
   foreach $owner (keys %$tbl)
   {
	$$tbl{$owner}{total} = 0;
	foreach $st (@status)
	{
		$query = $squery . ($owner eq 'nobody' ? "\'\'" : &db::db_quote($owner)) . $adds . ' AND status=' . &db::db_quote($st);
		undef @dt;
		$msg = &db::db_fetch($query,\@dt);
		return $msg if $msg;
		$$tbl{$owner}{$st} = $dt[0]{'count(date_created)'};
		$$tbl{$owner}{total} += $dt[0]{'count(date_created)'};
	}
   }
   return '';
}

sub get_queues
{
my ($qs, $user) = @_;
my $qquery = 'SELECT display,manipulate,admin,user_id,queue_id FROM queue_acl';
my $where = ' WHERE user_id=';
my $query;
my $msg;
my @dt;
my $i;

   $query = $qquery . $where . &db::db_quote($user);
   $msg = &db::db_fetch($query,\@dt);
   return $msg if $msg;
   return '' if $#dt < 0;
   for( $i = 0; $i <= $#dt; $i++ )
   {
   	push @$qs, $dt[$i]{queue_id} if $dt[$i]{display} || $dt[$i]{manipulate} || $dt[$i]{admin};
   }
   @$qs = sort @$qs;

   return '';
}

1;
