/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _BANK_SRAM_H_
#define _BANK_SRAM_H_

#include "EmulatorTypes.h"		// RAMSizeType

class SessionFile;

extern uaecptr	gMemoryStart;

	// These are also accessed by the DRAMBank functions.
extern uae_u32	gRAMBank_Size;
extern uae_u32	gRAMBank_Mask;
extern uae_u8*	gRAM_Memory;
extern uae_u8*	gRAM_MetaMemory;


class SRAMBank
{
	public:
		static void				Initialize		(RAMSizeType iRAMSize);
		static void				Reset			(void);
		static void				Save			(SessionFile&);
		static void				Load			(SessionFile&);
		static void				Dispose			(void);

		static void				SetBankHandlers	(void);

		static uae_u32			GetLong			(uaecptr iAddress);
		static uae_u32			GetWord			(uaecptr iAddress);
		static uae_u32			GetByte			(uaecptr iAddress);
		static void				SetLong			(uaecptr iAddress, uae_u32 iLongValue);
		static void				SetWord			(uaecptr iAddress, uae_u32 iWordValue);
		static void				SetByte			(uaecptr iAddress, uae_u32 iByteValue);
		static int				ValidAddress	(uaecptr iAddress, uae_u32 iSize);
		static uae_u8*			GetRealAddress	(uaecptr iAddress);
		static uae_u8*			GetMetaAddress	(uaecptr iAddress);
		static void				AddOpcodeCycles	(void);

		static uaecptr			GetMemoryStart	(void) { return gMemoryStart; }

	private:
		static void				InvalidAccess	(uaecptr iAddress, long size, Bool forRead);
		static void				ProtectedAccess	(uaecptr iAddress, long size, Bool forRead);
};

#endif /* _BANK_SRAM_H_ */
  
  
