/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef __FLTK_LCDWINDOW_H__
#define __FLTK_LCDWINDOW_H__

#include "omnithread.h"
#include <FL/Fl_Double_Window.H>

#include "Document.h"
#include "Skins.h"			// SkinElementType


class Dynamic_Image;
class MainWindow;

class LCD_window : public Fl_Double_Window
{
private:

	// -----------------------------------------------------------------------------
	// constants
	// -----------------------------------------------------------------------------

	// bit to indicate redraw is for LCD only
	enum
	{
		LCD_DAMAGE_BIT = 0x10
	};

public:

	// -----------------------------------------------------------------------------
	// constructor / destructor
	// -----------------------------------------------------------------------------

	LCD_window( MainWindow *parent );
	virtual ~LCD_window( void );

	// -----------------------------------------------------------------------------
	// public methods
	// -----------------------------------------------------------------------------

	void damageLcdArea();
	void setDocument(Document* doc) { _doc = doc; this->ResetSkin(); }
	Document* getDocument() { return _doc; }
	void ResetSkin (void);
	void setOn(bool on);
	bool isOn() { return _lcdOn; }

private:

	// -----------------------------------------------------------------------------
	// Fl_Double_Window overrides
	// -----------------------------------------------------------------------------

	virtual void draw();
	virtual int handle(int event);

	// -----------------------------------------------------------------------------
	// private methods
	// -----------------------------------------------------------------------------

	int updateBuffer(int);
	void initialize();
	void resetToDefault();

	void ConvertJpegToBmp (const void*, long, const void*&, int&, int&, int&);

	// -----------------------------------------------------------------------------
	// private data members
	// -----------------------------------------------------------------------------

	// Pixmap which holds the device case image
	Dynamic_Image* _case;

	// backing store buffer for LCD
	unsigned char* _buffer;

	// true if in drag sequence in LCD
	bool _penTracking;

	// current button we are tracking for a press or None if not
	SkinElementType _currentButton;

	// parent window
	MainWindow* _parent;

	// the current document (data)
	Document* _doc;

	// true if the LCD display is ON
	bool _lcdOn;
};

#endif /* __FLTK_LCDWINDOW_H__ */

