/*
 * findpath.h - Find a file via search path.
 *
 * Written by
 *  Tomi Ollila <Tomi.Ollila@tfi.net>
 *  Ettore Perazzoli <ettore@comm2000.it>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef _FINDPATH_H
#define _FINDPATH_H

#ifdef STDC_HEADERS
#if !defined (__riscos) && !defined (_MSC_VER)
#include <unistd.h>
#endif
#endif

#if defined (__MSDOS__) || defined(WIN32) || defined(OS2)
#define FINDPATH_SEPARATOR_CHAR         ';'
#define FINDPATH_SEPARATOR_STRING       ";"
#else
#define FINDPATH_SEPARATOR_CHAR         ':'
#define FINDPATH_SEPARATOR_STRING       ":"
#endif

char *findpath(const char *cmd, const char *syspath, int mode);

#endif /* _FINDPATH_H */
