/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#include "gqmpeg.h"

/*
 *-----------------------------------------------------------------------------
 * drag and drop uri utils
 *-----------------------------------------------------------------------------
 */

GList *uri_get_list(gchar *data)
{
	GList *list = NULL;
	gint b, e;

	b = e = 0;

	while (data[b] != '\0')
		{
		while (data[e] != '\r' && data[e] != '\n' && data[e] != '\0') e++;
		if (!strncmp(data + b, "file:", 5))
			{
			b += 5;
			list = g_list_append(list, g_strndup(data + b, e - b));
			}
		while (data[e] == '\r' || data[e] == '\n') e++;
		b = e;
		}

	return list;
}

gchar *uri_create_text(GList *list, gint *t, gint plain_text)
{
	GList *work;
	gchar *uri_text = NULL;
	gchar *leader = "file:";
	gchar *sep = "\r\n";
	gint total;
	gint leader_l;
	gint sep_l = strlen(sep);
	gchar *ptr;

	if (!list)
		{
		*t = 0;
		return NULL;
		}

	if (plain_text)
		{
		leader_l = 0;
		}
	else
		{
		leader_l = strlen(leader);
		}

	work = list;
	total = 0;

	/* compute length */

	while (work)
		{
		gchar *name = work->data;
		total += leader_l + strlen(name) + sep_l;
		work = work->next;
		}

	/* create list */
	uri_text = g_malloc(total + 1);
	ptr = uri_text;

	work = list;
	while (work)
		{
		gchar *name = work->data;
		if (leader_l > 0)
			{
			strcpy(ptr, leader);
			ptr += leader_l;
			}
		strcpy(ptr, name);
		ptr += strlen(name);
		strcpy(ptr, sep);
		ptr += sep_l;
		work = work->next;
		}
	ptr[0] = '\0';

	*t = total + 1;
	return uri_text;
}

/*
 *-----------------------------------------------------------------------------
 * drag and drop for main window
 *-----------------------------------------------------------------------------
 */
enum {
	TARGET_URI_LIST
};

static GtkTargetEntry main_drop_types[] = {
	{ "text/uri-list", 0, TARGET_URI_LIST }
};
static gint main_drop_count = 1;

static void dnd_main_get_data(GtkWidget *widget,
			GdkDragContext *context, gint x, gint y,
			GtkSelectionData *selection_data, guint info,
			guint time, gpointer data)
{
	if (info == TARGET_URI_LIST)
		{
		GList *list = uri_get_list(selection_data->data);

		if (!list) return;

		if (!list->next)
			{
			gchar *name = list->data;
			if (isdir(name))
				{
				playlist_append_from_dir(name, FALSE);
				}
			else if (is_playlist(name))
				{
				playlist_load_from_file(name, FALSE, TRUE, TRUE);
				if (status == STATUS_STOP)
					{
					current_song_set_and_play(playlist_get_first(), NULL);
					}
				}
			else if (drop_single_to_playlist)
				{
				playlist_add(name);
				if (status == STATUS_STOP)
					{
					current_song_set_and_play(playlist_get_count() - 1, NULL);
					}
				}
			else
				{
				current_song_set_and_play(-1, name);
				}
			}
		else
			{
			GList *work = list;
			while(work)
				{
				gchar *name = work->data;
				if (isdir(name))
					{
					playlist_append_from_dir(name, FALSE);
					}
				if (!is_playlist(name))
					{
					playlist_add(name);
					}
				work = work->next;
				}
			}
		g_list_foreach(list, (GFunc)g_free, NULL);
		g_list_free(list);
		}
}

void dnd_init()
{
	/* main window */
	gtk_drag_dest_set(mainwindow,
			GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP,
			main_drop_types, main_drop_count, 
			GDK_ACTION_COPY);
	gtk_signal_connect(GTK_OBJECT(mainwindow), "drag_data_received",
			dnd_main_get_data , NULL);
}


