/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#include "gqmpeg.h"

static void key_pressed(GtkWidget *widget, GdkEventKey *event)
{
	static gint last_key = 0;
	static gint last_state = 0;
	static guint32 last_time = 0;

	/* cheap hacks/checks to avoid problems caused by holding down
	 * keys with fast repeat rates */
	if (event->keyval == last_key && event->state == last_state &&
			last_time + 500 >= event->time)
		{
		return;
		}
	else
		{
		last_key = event->keyval;
		last_state = event->state;
		last_time = event->time;
		}

	if (debug_mode) printf("key pressed: %d\n", event->keyval);

	if (event->state & GDK_CONTROL_MASK)
		{
		switch (event->keyval)
			{
			case 's':
				btn_shuffle_pressed();
				break;
			case 'r':
				btn_repeat_pressed();
				break;
			case 't':
				time_toggle_pressed();
				break;
			case 'q':
				gqmpeg_exit();
				break;
			case 'a':
				show_about_info();
				break;
			case 'o':
				show_configuration_window();
				break;
			case 'i':
				btn_iconify_pressed();
				break;
			case '-':
				btn_balance_left_pressed();
				btn_balance_released();
				break;
			case '+': case '=':
				btn_balance_right_pressed();
				btn_balance_released();
				break;
			default:
				break;
			}
		}
	else
		{
		switch (event->keyval)
			{
			case 'p': case ' ':
				btn_play_pressed();
				break;
			case 's':
				btn_stop_pressed();
				break;
			case 'n':
				btn_next_down();
				btn_next_pressed();
				break;
			case 'b':
				btn_prev_down();
				btn_prev_pressed();
				break;
			case 'l':
				playlist_window_show();
				break;
			case 'm':
				btn_mixer_pressed();
				break;
			case 'w':
				mode_button_pressed();
				break;
			case 'i':
				current_song_info_pressed();
				break;
			case '-':
				btn_volume_down_pressed();
				btn_volume_released();
				break;
			case '+': case '=':
				btn_volume_up_pressed();
				btn_volume_released();
				break;
			case '1':
				preset_1_pressed();
				break;
			case '2':
				preset_2_pressed();
				break;
			case '3':
				preset_3_pressed();
				break;
			case '4':
				preset_4_pressed();
				break;
			case '5':
				preset_5_pressed();
				break;
			case '6':
				preset_6_pressed();
				break;
			case '7':
				preset_7_pressed();
				break;
			case '8':
				preset_8_pressed();
				break;
			case '9':
				preset_9_pressed();
				break;
			case '0':
				preset_10_pressed();
				break;
			default:
				break;
			}
		}
}

static void set_icon_for_window(GtkWidget *window)
{
	GdkPixmap *icon = NULL;
	GdkBitmap *mask = NULL;
	GtkStyle *style = gtk_widget_get_style(window);
	icon = gdk_pixmap_create_from_xpm_d(window->window, &mask,
		&style->bg[GTK_STATE_NORMAL], (gchar **)gqmpeg_icon_xpm);
	gdk_window_set_icon(window->window, NULL, icon, mask);
}

static void destroy()
{
	gqmpeg_exit();
}

void create_main_window(gchar *skin_path)
{
	mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (mainwindow), "delete_event",(GtkSignalFunc) destroy, NULL);
	gtk_signal_connect (GTK_OBJECT (mainwindow), "key_press_event",(GtkSignalFunc) key_pressed, NULL);
	gtk_window_set_policy (GTK_WINDOW (mainwindow),FALSE,FALSE,TRUE);
	gtk_container_border_width (GTK_CONTAINER (mainwindow), 0);
	gtk_window_set_title (GTK_WINDOW (mainwindow), "GQmpeg");
	gtk_window_set_wmclass(GTK_WINDOW (mainwindow), "gqmpeg", "GQmpeg");

	gtk_widget_realize(mainwindow);
	set_icon_for_window(mainwindow);

	/* set up display */
	display_area = gtk_drawing_area_new();

	setup_display();

	gtk_container_add (GTK_CONTAINER (mainwindow), display_area);

	gtk_widget_show(display_area);

	gtk_widget_realize(display_area);

/* ----	dnd_set_drop(display_area, display_area->window);
*/
	/* create pop-up menus */
	main_menu = create_main_menu();
	dir_menu = create_dir_menu();
	file_menu = create_file_menu();
	file_menu_list = create_file_menu_list();
	playlist_menu = create_playlist_menu();
	playlist_menu_custom = create_playlist_menu_custom();

	if (skin_path)
		{
		printf(_("loading skin..\n"));
		if (!change_to_skin(skin_path))
			{
			if (default_skin)
				{
				if (!change_to_skin(default_skin))
					{
					printf(_("Default skin not loaded, using built-in default\n"));
					change_to_skin(NULL);
					}
				}
			else
				{
				printf(_("Skin not loaded, using built-in default\n"));
				change_to_skin(NULL);
				}
			}
		}
	else if (default_skin)
		{
		if (!change_to_skin(default_skin))
			{
			printf(_("Skin in config file not loaded, using built-in default\n"));
			change_to_skin(NULL);
			}
		}
	else
		{
		change_to_skin(NULL);
		}

	if (remember_window_position && alternate_skin)
		{
		mode_button_pressed();
		}

	if (!wm_decorations)
		{
		gdk_window_set_decorations (mainwindow->window, 0);
		}

	playlist_window_update_titles();
}
