program tex2ex;

{ Strip TeX file prepared by M-Tx 0.30 -> PMX 1.3 so the resulting
  file can be imported into LaTeX }

var infile, outfile: text;
    buffer, infilename, outfilename: string;

procedure fatalerror(message: string);
begin  writeln (message);
  begin close(outfile); rewrite(outfile); close(outfile); halt(10);
  end;
end;

procedure OpenFiles;
var i, j, testin: integer;
    basename, param: string;
begin
  if ParamCount<1 then
  begin  writeln('Please type a basename (<9 characters, no dots):');
    readln(basename);
  end
  else basename:=paramstr(1);
  infilename := basename+'.tex';  outfilename := basename+'.ex';
{$I-}
  assign(infile,infilename);  reset(infile);  testin := ioresult;
  assign(outfile,outfilename);  rewrite(outfile);
{$I+}
  if testin<>0 then FatalError('Input file '+infilename+' not found');
  writeln('Writing to ',basename,'.ex');
end;

function match(buffer, pattern: string; position: integer): boolean;
  var i, l: integer;
begin  match := false;  l:=length(pattern);  position:=position-1;
  if length(buffer)-position<l then exit;
  for i:=1 to l do
    if buffer[i+position]<>pattern[i] then exit;
  match:=true;
end;

procedure match_and_cut (var s: string; pattern: string);
  var i, j, m, n: integer;
begin  i:=1; j:=1; n:=length(s); m:=length(pattern);
  while i<=n do
  begin if match(s,pattern,i) then inc(i,m)
      else begin s[j]:=s[i]; inc(i); inc(j); end;
  end;
  s[0]:=char(j-1);
end;

procedure Process;
  const nhits = 7;
        ncuts = 2;
        hit: array[1..nhits] of string = ( '\immediate', '\let\:',
           '\nopagenumbers', '\input', '\readmod', '\vfill\eject',
           '\bye');
        cut: array[1..ncuts] of string = ('\startmuflex','\endmuflex');
  var i: integer;
begin
  for i:=1 to ncuts do match_and_cut(buffer,cut[i]);
  for i:=1 to nhits do
    if match(buffer,hit[i],1) then begin buffer:=''; exit; end;
end;

procedure CloseFiles;
begin  close(outfile);  close(infile);
end;

begin
  OpenFiles;
  repeat buffer:=''; readln(infile,buffer); Process;
    if buffer<>'' then writeln(outfile,buffer);
  until eof(infile);
  CloseFiles;
end.

