/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "mtx.pas" */


#include "cfuncs.h"


#define MTX_G
#include "mtx.h"


#ifndef MTXLINE_H
#include "mtxline.h"
#endif

#ifndef STRINGS_H

#endif

#ifndef STATUS_H
#include "status.h"
#endif

#ifndef NOTES_H
#include "notes.h"
#endif


#define flagged         "8136"

#define crotchet        16

#define tex_escape      '\\'


typedef boolean sticky['z' + 1 - 'a'];


static sticky note_attrib[maxvoices], rest_attrib[maxvoices];


static short logTwo(short denom)
{
  short l = 0;

  while (denom > 1) {
    l++;
    denom /= 2;
  }
  return l;
}


static boolean dotted(short n)
{
  boolean Result;

/* p2c: mtx.pas: Note: Eliminated unused assignment statement [338] */
  if (n == 0)
    return false;
  if (n != n / 3 * 3)
    return false;
  n /= 3;
  while ((n & 1) == 0)
    n /= 2;
  return (n == 1);
}


/* RESTS should have a third parameter OFFSET.  At present we in effect
   assume OFFSET+LENGTH to be a multiple of METERDENOM. */
char *rests(char *Result, short len, short meterdenom, boolean blind)
{
  char r[256], bl[256];
  char STR1[256];

  if (blind)
    strcpy(bl, "b");
  else
    *bl = '\0';
  if (len == 0)
    return strcpy(Result, "");
  else {
    if (len == meterdenom * 128) {
      sprintf(Result, "r9%s ", bl);
      return Result;
    } else {
      if (dotted(len)) {
	rests(r, len - len / 3, meterdenom, false);
	r[2] = 'd';
	sprintf(Result, "%s%s ", r, bl);
	return Result;
      } else if (len >= 64 / meterdenom) {
	sprintf(Result, "%sr%c%s ",
		rests(STR1, len - 64 / meterdenom, meterdenom, blind),
		durations[whole + logTwo(meterdenom) - 1], bl);
	return Result;
      } else
	return (rests(Result, len, meterdenom * 2, blind));
    }
  }
}


static char *attribs(char *Result, char *note)
{
  char a[256];
  short i = 2;
  short l;
  char n;

  *a = '\0';
  l = strlen(note);
  while (i <= l) {
    n = note[i-1];
    if (n == 'x')
      i = l;
    else if (islower(n))
      sprintf(a + strlen(a), "%c", n);
    i++;
  }
  return strcpy(Result, a);
}


static void checkSticky(char *note, boolean *attrib)
{
  short i = 2;
  short l;
  char c;
  char a[256];

  if (*note == '\0')
    return;
  l = strlen(note);
  while (i <= l) {
    c = note[i-1];
    if (islower(c)) {
      if (i < l && note[i] == ':') {
	delete1(note, i + 1);
	l--;
	attrib[c - 'a'] = !attrib[c - 'a'];
      } else
	attrib[c - 'a'] = false;
    }
    i++;
  }
  attribs(a, note);
  for (c = 'z'; c >= 'a'; c--) {
    if (attrib[c - 'a'] && pos1(c, a) == 0)
      insertchar(c, note, 3);
  }
}


void checkOctave(voice_index voice, char *note)
{
  short i;

  i = pos1('=', note);
  if (i > 0) {
    delete1(note, i);
    setOctave(voice);
  }
  if (octave(voice) == blank)
    return;
  i = 2;
  do {
    if (note[i-1] == '+' || note[i-1] == '-') {
      newOctave(voice, note[i-1]);
      delete1(note, i);
    } else if (pos1(note[i-1], terminators) > 0)
      i = strlen(note);
    i++;
  } while (i <= strlen(note));
  insertchar(octave(voice), note, 3);
  resetOctave(voice);
}


void markDebeamed(voice_index voice, char *note)
{
  if (isVocal(voice) && afterSlur(voice) == 0 && unbeam_if_vocal &&
      pos1(duration(voice), flagged) > 0)
    insertchar('a', note, 2);
}


static short barLength(char *meter)
{
  short n1, n2, pn1, pn2;

  readMeter(meter, &n1, &n2, &pn1, &pn2);
  return (n1 * (64 / n2));
}


static boolean isMultiBarRest(char *rest_)
{
  boolean Result;

/* p2c: mtx.pas: Note: Eliminated unused assignment statement [338] */
  if (strlen(rest_) < 3)
    return false;
  if (rest_[1] != 'm')
    return false;
  if (multi_bar_rest)
    error("Only one multibar rest allowed per line", print);
  multi_bar_rest = true;
  return true;
}


/* static variables for scanMusic: */
struct LOC_scanMusic {
  voice_index voice;
  char note[256];
  boolean beam_next;
  short bar, bar_length, count, dotme, l, nl, ngrace, nmulti;
} ;

/* static variables for countIt: */
struct LOC_countIt {
  struct LOC_scanMusic *LINK;
} ;

static void incbar(short nl, struct LOC_countIt *LINK)
{
  LINK->LINK->bar_length += nl;
  if (LINK->LINK->bar_length > LINK->LINK->bar && meternum > 0)
    error3(LINK->LINK->voice, "Bar end occurs in mid-note");
}

static void countIt(struct LOC_scanMusic *LINK)
{
  struct LOC_countIt V;

  V.LINK = LINK;
  if (LINK->ngrace > 0) {
    LINK->ngrace--;
    return;
  }
  if (LINK->nmulti > 0) {
    LINK->nmulti--;
    return;
  }
  /* dur2:=durationCode(note);
    if dur2<>unspecified then dur1:=dur2;
    nl:=count64[dur1];  incbar(nl);
    if pos1(comma,note)>0 then incbar(nl div 2)
    else begin
      if pos1(dot,note)>0 then dotme:=2 else dotme:=1;
      if not split_dots and (dotme=2) then
      begin dotme:=1; incbar(nl); end;
      l := length(note);  i:=2;  dotadd:=false;
      while i <= l do
      begin  if pos1(note[i],dotcode)>0 then
        begin  nl:=nl div 2;  incbar(nl);  dotadd:=true; end
        else if pos1(note[i],terminators)>0 then i:=l;
        inc(i);
      end;
    end; */
  if (LINK->count % 3 != 0 &&
      (LINK->note[0] != rest && note_attrib[LINK->voice-1]['d' - 'a'] ||
       LINK->note[0] == rest && rest_attrib[LINK->voice-1]['d' - 'a']))
    LINK->count += LINK->count / 2;
/* p2c: mtx.pas, line 151:
 * Note: Using % for possibly-negative arguments [317] */
  incbar(LINK->count, &V);
  /*        begin  nl:=nl div 2;  incbar(nl);  end;  */
  /* ------------ did you forget duration under beam? ------------ */
  if (LINK->beam_next && LINK->nl / LINK->dotme >= crotchet)
    warning("Note under beam has length 1/4 or more", print);
  LINK->beam_next = false;
  /* ------------------------------------------------------------- */
  LINK->l = pos1(multi_group, LINK->note);
  if (LINK->l <= 0)
    return;
  predelete(LINK->note, LINK->l);
  getNum(LINK->note, &LINK->nmulti);
  LINK->nmulti--;
}

static void maybeGroup(struct LOC_scanMusic *LINK)
{
  switch (LINK->note[0]) {

  case start_beam:
    LINK->beam_next = true;
    break;

  case grace_group:
    if (strlen(LINK->note) == 1)
      LINK->ngrace = 1;
    else
      LINK->ngrace = pos1(LINK->note[1], digits);
    /* bug if ngrace>9 */
    if (LINK->ngrace > 0)
      LINK->ngrace--;
    break;
  }
}


void scanMusic(voice_index voice_, short *left_over)
{
  struct LOC_scanMusic V;
  char buf[256], enote[256], xnote[256];
  boolean has_next = false, done = false;
  char dur1, lastdur;
  music_word nscan;
  char STR1[256];

  V.voice = voice_;
  if (extended_dots)
    strcpy(terminators, "d.x");
  resetInfo(V.voice, buf);
  *left_over = 0;
  V.bar = full_bar;
  V.bar_length = 0;
  V.ngrace = 0;
  V.nmulti = 0;
  if (meternum == 0)
    V.bar = 32000;
  dur1 = duration(V.voice);
  lastdur = dur1;
  V.beam_next = false;
  do {
    getNextMusWord(buf, V.note, &nscan);
    V.count = 0;
    /*    if isNoteOrRest(note) and not (isPause(note) or isMultibarRest(note))
          then note:=toStandard(note); */
    if (nscan == mword) {
      if (V.bar_length > 0)
	error3(V.voice, "Meter change only allowed at start of bar");
      else
	V.bar = barLength(V.note);
    } else if (nscan == rword) {
      if (!(isPause(V.note) || isMultiBarRest(V.note))) {
	parseNote(V.note, xnote, dur1, &lastdur, &V.count);
	checkSticky(V.note, rest_attrib[V.voice-1]);
      }
    }
    if (*V.note != '\0')
      appendNote(V.voice, nscan);
    strcpy(enote, V.note);
    if (nscan == abcdefg) {
      if (!multi_bar_rest && V.ngrace + V.nmulti == 0) {
	parseNote(enote, xnote, dur1, &lastdur, &V.count);
	if (*xnote != '\0') {
	  checkSticky(enote, note_attrib[V.voice-1]);
	  appendToLine(V.voice, enote);
	  appendNote(V.voice, nscan);
	  strcpy(enote, xnote);
	}
	checkSticky(enote, note_attrib[V.voice-1]);
      }
    }
    appendToLine(V.voice, enote);
    if (*V.note == '\0')   /* !!! else word_bound[here]:=length(line); */
      done = true;
    sprintf(STR1, "%c", barsym);
    if (!strcmp(V.note, STR1)) {
      if (meternum == 0)
	error3(V.voice, "You may not use bar lines in barless music");
      else if (V.bar_length == 0)
	markBar(V.voice);
      else if (numberOfBars(V.voice) == 0 && V.bar_length < V.bar) {
	if (has_next)
	  has_next = false;   /*Should check whether pickups are equal*/
	else if (*left_over > 0)
	  error3(V.voice, "Bar is too short");
	*left_over = V.bar_length;
	V.bar_length = 0;
      }
    }
    if (nscan == nextvoice) {
      if (V.bar_length > 0)
	error3(V.voice, "Next voice before bar is full");
      else
	barForward(V.voice, -1);
      has_next = true;
    } else if (isPause(V.note))
      V.bar_length += V.bar;
    else if (!multi_bar_rest) {   /*do nothing*/
      if (!done && isNoteOrRest(V.note))
	countIt(&V);
      else
	maybeGroup(&V);
    }
    dur1 = lastdur;
    if (V.bar_length >= V.bar && V.ngrace + V.nmulti == 0) {
      barForward(V.voice, V.bar_length / V.bar);
      V.bar_length %= V.bar;
/* p2c: mtx.pas, line 238:
 * Note: Using % for possibly-negative arguments [317] */
    }
  } while (!done);
  setExtraLength(V.voice, V.bar_length);
  resetDuration(V.voice, dur1);
  regroup(V.voice);
}


void initMTX(void)
{
  voice_index i;
  char j;

  for (i = 0; i <= maxvoices - 1; i++) {
    for (j = 'a'; j <= 'z'; j++)
      note_attrib[i][j - 'a'] = false;
  }
  memcpy(rest_attrib, note_attrib, maxvoices * sizeof(sticky));
}




/* End. */
