



package Debian::DebConf::FrontEnd;
use Debian::DebConf::Priority;
use Debian::DebConf::Config;
use Debian::DebConf::Base;
use Debian::DebConf::Log ':all';
use strict;
use vars qw(@ISA);
@ISA=qw(Debian::DebConf::Base);


sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self  = bless $proto->SUPER::new(@_), $class;
	$self->{elements}=[];
	$self->{interactive}='';
	$self->{capb}='';
	$self->{title}="";
	return $self
}


sub makeelement {
	my $this=shift;
	my $frontend_type=shift;
	my $question=shift;
	
	my $type=$frontend_type.'::'.ucfirst($question->template->type);
	debug 2, "Trying to make element of type $type";
	my $element=eval qq{
		use Debian::DebConf::Element::$type;
		Debian::DebConf::Element::$type->new;
	};
	debug 2, "Failed with $@" if $@;
	if (! ref $element) {
		return;
	}
	$element->frontend($this);
	$element->question($question);
	return $element;
}


sub add {
	my $this=shift;
	my $question=shift || die "\$question is undefined";
	my $priority=shift;

	my $visible=1;

	$visible='' if ! $this->interactive;
	
	$visible='' unless Debian::DebConf::Priority::high_enough($priority);
	
	$visible='' if Debian::DebConf::Config::showold() eq 'false' &&
		$question->flag_isdefault eq 'false';
	
	my $element;
	if ($visible) {
		my ($frontend_type)=ref($this)=~m/DebConf::FrontEnd::(.*)/;
		$element=$this->makeelement($frontend_type, $question) ||
			 die "Unknown type of element";

		$visible=$element->visible;
	}
	if (! $visible) {
		$element=$this->makeelement('Noninteractive', $question) ||
			return; # no noninteractive element of this type.
	}
	
	push @{$this->{elements}}, $element;
	return $element->visible;
}


sub go {
	my $this=shift;

	debug 2, "preparing to ask questions";
	foreach my $element (@{$this->elements}) {
		my $value=$element->show;
		if ($this->backup) {
			$this->{elements}=[];
			$this->backup('');
			return;
		}
		$element->question->value($value);
		$element->question->flag_isdefault('false')
			if $element->visible;
	}
	$this->clear;
	return 1;
}


sub clear {
	my $this=shift;
	
	$this->{elements}=[];
}


sub default_title {
	my $this=shift;
	
	$this->title("Configuring ".ucfirst(shift));
}


1
