// defaults.cc
//
//  Copyright 1999 Daniel Burrows
//
//  Defaults for Aptitude.

#include "config/keybindings.h"

void init_defaults()
{
  global_bindings.set("ExitScreen", 'q');
  global_bindings.set("CycleScreen", '\t');

  global_bindings.set("ToggleExpanded", KEY_ENTER);

  global_bindings.set("SelectParent", '^');
  global_bindings.set("SelectNext", KEY_DOWN);
  global_bindings.set("SelectPrev", KEY_UP);
  global_bindings.set("NextPage", KEY_NPAGE);
  global_bindings.set("PrevPage", KEY_PPAGE);
  global_bindings.set("ListTop", KEY_HOME);
  global_bindings.set("ListBottom", KEY_END);
  global_bindings.set("ListSearch", '/');

  global_bindings.set("EditDelBack", KEY_BACKSPACE);
  global_bindings.set("EditDone", KEY_ENTER);

  global_bindings.set("SelectPackage", '+');
  global_bindings.set("DeselectPackage", '-');
  global_bindings.set("HoldPackage", '=');
  global_bindings.set("PurgePackage", '_');

  global_bindings.set("PackageVersions", 'v');
  global_bindings.set("PackageDependencies", 'd');
  global_bindings.set("PackageDescription", 'i');
  global_bindings.set("PackageInfoScreen", KEY_ENTER);
  global_bindings.set("ForgetNewPackages", 'f');

  global_bindings.set("UpdatePackageList", 'u');
  global_bindings.set("DoInstallRun", 'g');
}
