// pkg_node.h	-*-c++-*-
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  In the fine tradition of breaking header files up into their smallest
// usable components..

#ifndef PKG_NODE_H
#define PKG_NODE_H

#include "vs_treeitem.h"

class pkg_tree_node:virtual public vs_treeitem
// Provides some extra package-related interfaces.
{
public:
  virtual void select()=0;
  virtual void hold()=0;
  virtual void remove()=0;
  virtual void purge()=0;

  bool dispatch_char(chtype ch);
  // IMPORTANT NOTE: pkg_tree_node::dispatch_char() does NOT call
  // vs_treeitem::dispatch_char!
};

#endif
