#!	/bin/bash

. ./common.sh

umask 022

export LANG=C

# dpkg needs this.
export PATH=/sbin:/usr/sbin:$PATH

# base-contents file name
basecontents="base-contents.txt"

if [ $# -ne 2 ]; then
	echo "Usage:	"$0 "debian-archive-directory debian-version" 1>& 2
	cat 1>&2 << EOF

	Creates a new base archive.

	debian-archive-directory: the local copy of the Debian archive.
	debian-version: version of the Debian release

EOF
	exit -1;
fi

# Set this to the location of the package archive.
archive=$1

version=`echo $2 | sed -e 's/\./_/'`

# temporary directories
B=${tmpdir}/boot-floppies/base-tmp-$$
P=${tmpdir}/boot-floppies/partial-tmp-$$
rm -rf $B $P			# just to be sure

# home of the scripts used by this script
scripts=`pwd`/scripts/basedisks

# PARTIAL_PACKAGES are an ugly kludge. The proper fix would be to move
# the needed files to base packages.
PARTIAL_PACKAGES=`cat $scripts/PARTIAL_PACKAGES_all \
 $scripts/PARTIAL_PACKAGES_${arch}`
if [ "$PARTIAL_PACKAGES" ]; then
    echo -e "WARNING: Some files from the following packages must be in the \n\
base system, but currently are not provided by any base package: \n\n\
$PARTIAL_PACKAGES\n"
fi

# check to see if all the needed packages are in the archive
info "checking for required packages from PACKAGES and PARTIAL_PACKAGES"
exit=false
for i in $scripts/PACKAGES_all $scripts/PACKAGES_${arch} \
 $scripts/PARTIAL_PACKAGES_all $scripts/PARTIAL_PACKAGES_${arch}; do
	if [ ! -f $i ]; then
		warn "can't open $i"
		exit=true
	fi
done
if $exit; then
	exit -1;
fi

# expand the package names into full pathnames.
PACKAGE_PATHS=`make_paths \`cat $scripts/PACKAGES_all \
    $scripts/PACKAGES_${arch}\``
if [ $? -ne 0 ]; then
	exit -1;
fi

# Setting this variable makes packages that use debconf install
# noninteractively.
DEBIAN_FRONTEND=noninteractive
export DEBIAN_FRONTEND

info "extracting required packages (PACKAGES_all and PACKAGES_$arch)"
make_tmpdir $B
# TODO It should extract only essential packages and the libs those need.
for i in $PACKAGE_PATHS; do
	debug extracting $i
	dpkg-deb --extract $i $B
done

if [ "$PARTIAL_PACKAGES" ]; then
	info "extracting required partial packages"
	PARTIAL_PACKAGE_PATHS=`make_paths $PARTIAL_PACKAGES`
	if [ $? -ne 0 ]; then
		exit -1
	fi

	make_tmpdir $P
	for i in $PARTIAL_PACKAGE_PATHS; do
		debug extracting $i
		dpkg-deb --extract $i $P
	done
	(cd $P && tar -cf - `cat $scripts/PARTIAL_PACKAGE_FILES_all \
	    $scripts/PARTIAL_PACKAGE_FILES_${arch}`) \
	    | tar xlpf - -C $B

	rm -rf $P
fi

# miscellaneous stuff normally done by the postinst scripts
if [ ! -f $B/usr/bin/perl-5.005 -a -f $B/usr/bin/perl-5.005.dist ]; then
	debug "moving perl-5.005.dist to perl-5.005"
        mv $B/usr/bin/perl-5.005.dist $B/usr/bin/perl-5.005
fi
if [ ! -f $B/usr/bin/perl ]; then	# note: this is removed below
	debug "making perl symlink"
	ln -s perl-5.005 $B/usr/bin/perl
fi
if [ ! -f $B/bin/sh ]; then
	debug "making sh symlink"
	ln -s bash $B/bin/sh
fi

echo -n > $B/var/lib/dpkg/status
echo -n > $B/var/lib/dpkg/available

info "making base device list in $B/dev"

# non-architecture-dependant devices
( cd $B/dev && /sbin/MAKEDEV generic hde hdf hdg hdh sde sdf sdg sdh scd-all initrd rtc )
testexit

# any architecture-dependant devices
case "$arch" in
	alpha)
		(cd $B/dev && /sbin/MAKEDEV fd0 fd1 )
		testexit
		;;
	i386)
		(cd $B/dev && /sbin/MAKEDEV isdn-io eda edb sonycd mcd mcdx cdu535 lmscd sbpcd aztcd bpcd optcd sjcd cm206cd gscd dac960 ida)
		testexit
		;;
	m68k)
#		# temporarily added sdc, sdd and hdc, hdd until MAKEDEV generic gets fixed for m68k
		(cd $B/dev && /sbin/MAKEDEV adc add ade adf sdc sdd hdc hdd)
		testexit
		;;
	powerpc)
		(cd $B/dev && /sbin/MAKEDEV hdc hdd fd0 fd1 isdn-io m68k-mice )
		testexit
		# For 2.2.18pre21 and on, we need the new input layer's
		# devices.  Yes, this is the wrong place to do this.
		mkdir $B/dev/input
		mknod $B/dev/input/js0 c 13 0
		mknod $B/dev/input/js1 c 13 1
		mknod $B/dev/input/js2 c 13 2
		mknod $B/dev/input/js3 c 13 3
		mknod $B/dev/input/mouse0 c 13 32
		mknod $B/dev/input/mouse1 c 13 33
		mknod $B/dev/input/mouse2 c 13 34
		mknod $B/dev/input/mouse3 c 13 35
		mknod $B/dev/input/mice c 13 63
		mknod $B/dev/input/event0 c 13 64
		mknod $B/dev/input/event1 c 13 65
		mknod $B/dev/input/event2 c 13 66
		mknod $B/dev/input/event3 c 13 67

		# Maybe remove amiga/atari mice also?  What about usbmouse?
		rm -f $B/dev/adbmouse
		ln -s input/mice $B/dev/mouse
		ln -s input/js0 $B/dev/js0
		ln -s input/js1 $B/dev/js1
		;;
	sparc)
		(cd $B/dev && /sbin/MAKEDEV hdc hdd busmice )
		;;
	*)
		warn "dubious device support for $arch"
		;;
esac


info "pre-configuring base system in $B"
(cd $B; chroot $B sbin/ldconfig.new) ; testexit
trap "umount $B/proc" 0

# setup /etc/fstab for the proper operation lilo's liloconfig
echo '# UNCONFIGURED FSTAB FOR BASE SYSTEM' > $B/etc/fstab
set_file_perms $B/etc/fstab

chroot $B mount -t proc proc /proc

# [ED] Sparc installation requires step by step installation of ldso, base-files
#      libc6 & dpkg.
# BTW, make_paths shouldn't be called out of the directory where updates live !
# base-files & ldso have to be installed & configured before any other pkgs
info "configuring base-files base-passwd ldso"
# base-passwd won't configure unless it thinks dpkg is installed, so fool it
dpkg-awk 'package:.*dpkg$' -- ^foo >> $B/var/lib/dpkg/status
corepkgs=`make_paths base-files base-passwd ldso`
(cd $B && dpkg --root=. --install --force-depends --force-auto-select $corepkgs)
testexit

# dpkg predepends on libc6 but can be configured anyway
info "configuring dpkg"
corepkgs=`make_paths dpkg`
(cd $B && dpkg --root=. --install --force-depends --force-auto-select $corepkgs)
testexit

# libc6 fails to unpack before dpkg is configured (at least on sparc)
case "$arch" in
	alpha)
		libc6pack="libc6.1"
		;;
	*)
		libc6pack=libc6
		;;
esac
info "configuring $libc6pack"
corepkgs=`make_paths $libc6pack`

# set default timezone for boot-floppies to Factory, libc6 install
# postinst script sets timezone.  This avoids a postinst question.
echo UTC > $B/etc/timezone
cp $B/usr/share/zoneinfo/Factory $B/etc/localtime
(cd $B && dpkg --root=. --install --force-depends --force-auto-select $corepkgs)
testexit

# remove our temporary perl symlink before installing perl
rm -f $B/usr/bin/perl

# perl-5.005-base needs to be configured before /usr/bin/perl exists (not sure
# if this is required this early)
info "configuring perl-5.005-base"
corepkgs=`make_paths perl-5.005-base`
(cd $B && yes '' | \
    dpkg --root=. --install --force-depends --force-auto-select $corepkgs)
testexit

# avoid netbase hostname -i queries
mkdir -p $B/etc/network
touch $B/etc/network/spoof-protect

info "unpacking remaining base packages"
(cd $B &&
    perlbase=`make_paths perl-5.005-base`
    # other pkgs installed at this time:
    #     $libc6pack dpkg base-files base-passwd ldso
    # FIXME: why re-unpack these?  why run dpkg once per pkg?
    for package in $PACKAGE_PATHS; do
	if [ ! $package =  $perlbase ]; then
		debug "unpacking package $package"
		dpkg --root=. --unpack --force-auto-select --force-depends \
		     --force-overwrite $package
	fi
    done
)  
testexit

# remove temporary file again
rm -f $B/etc/network/spoof-protect

# don't start any daemons
mv $B/sbin/start-stop-daemon $B/sbin/start-stop-daemon.REAL
cp $B/bin/true $B/sbin/start-stop-daemon

# Miscellaneous stuff to avoid problems with the postinst scripts.
# Most of those should be fixed in the scripts.

info "setting the default dselect acquisition method to apt"
echo "apt apt" >$B/var/lib/dpkg/cmethopt
chmod 644 $B/var/lib/dpkg/cmethopt

DEBIAN_FRONTEND=noninteractive
export DEBIAN_FRONTEND

info "configuring remaining packages"
# FIXME: ppp insists that /var/run/syslogd.pid exist.
echo "1" > $B/var/run/syslogd.pid

# allow console-tools to configure when building with serial console.
mv $B/bin/loadkeys $B/bin/loadkeys.REAL

if [ -f $B/var/lib/dpkg/info/pcmcia-cs.postinst ]; then
	mv $B/var/lib/dpkg/info/pcmcia-cs.postinst $B 
	cp $scripts/pcmcia-cs.postinst $B/var/lib/dpkg/info/pcmcia-cs.postinst
	pcmcia=yes
fi

# modutils insists that /lib/modules/`uname -r` exists
mkdir $B/lib/modules/`uname -r`

# create /etc/default/pump so pump doesn't ask any questions
touch $B/etc/default/pump

(cd $B && yes '' | \
    dpkg --root=. --configure --pending --force-configure-any --force-depends \
    || yes '' | dpkg --root=. --configure --pending  # try running again
)
testexit

# unhack
rm -f $B/etc/fstab

chroot $B umount /proc
chroot $B umount /dev/pts || true	# broken i386 stock kernel, disabled
settrapzero

# copying fonts not included in kbd-data
for font in `find $scripts/../rootdisk/consolefonts -type f`; do
       cp -f $font $B/usr/share/consolefonts
       gzip -9f $B/usr/share/consolefonts/`basename $font` || true
done

if [ "$pcmcia" = yes ]; then
	mv $B/pcmcia-cs.postinst $B/var/lib/dpkg/info/
fi

# restore loadkeys
mv $B/bin/loadkeys.REAL $B/bin/loadkeys

# restore start-stop-daemon
mv $B/sbin/start-stop-daemon.REAL $B/sbin/start-stop-daemon
echo Factory > $B/etc/timezone
rm -f $B/usr/share/zoneinfo/localtime
rm -f $B/etc/kbd/default.map*
# fix LILO
rm -f $B/boot/*.preserved
# FIXME: is this whole kludge still needed?
# remove kludge for modutils
rm -rf $B/lib/modules/`uname -r`
rm -f $B/etc/modules.conf.old
# clean-up /tmp
rm -f $B/tmp/*

# FIXME: ppp insists that /var/run/syslogd.pid exist.
rm -f $B/var/run/syslogd.pid

# will be copied from or created by the root disk
rm -f $B/etc/{modules.conf,modules}
rm -f $B/etc/init.d/network $B/etc/network/interfaces
if [ x$pcmcia = xyes ]; then
	rm -f $B/etc/pcmcia.conf $B/etc/pcmcia/serial.opts \
	  $B/etc/pcmcia/cdrom.opts $B/etc/pcmcia/network.opts
fi


info "removing extraneous dselect methods"
# for the disk method, all we want is NFS
mv $B/usr/lib/dpkg/methods/disk/names $B/usr/lib/dpkg/methods/disk/names.orig
grep nfs $B/usr/lib/dpkg/methods/disk/names.orig > $B/usr/lib/dpkg/methods/disk/names

info "setting /root perms more stringently"
chmod --recursive go-rx /root

info "creating $basecontents"
(cd $B && dpkg --root=. -l) > ${basecontents}

echo '#! /bin/sh

echo "WARNING!  You are attempting to boot an unconfigured base system.
You need to configure it before proceeding.  To do this, you need
to reboot using the Debian Rescue disk and select the
\"Configure the Base System\" option from the installation menu.

Please make sure that the Debian Rescue Disk is in the boot
floppy drive and press <ENTER> to reboot:
"

read input
reboot' > $B/sbin/unconfigured.sh

chmod 755 $B/sbin/unconfigured.sh

# one can put a setup.sh file here for putting on the base disks;
# we don't use this anymore however
if [ -f $scripts/setup.sh ]; then
	info "installing $scripts/setup.sh to be run by /etc/init.d/rcS"
	install --mode=0755 -o root -g root $scripts/setup.sh $B/sbin/
fi

# copy termwrap
install -m755 $scripts/termwrap $B/sbin/

info "building base${version}.tgz"
find $B -name '*.dpkg-old' | xargs rm -f
find $B/var/lib/dpkg/ -name '*-old' | xargs rm -f
(cd $B && tar clf - .) | gzip --best > base${version}.tgz

rm -rf $B

info "splitting base disks"
case $arch in
    i386)
	./utilities/floppy_split base${version}.tgz base12 1200
	./utilities/floppy_split base${version}.tgz base14 1440
	;;
    *)
	./utilities/floppy_split base${version}.tgz base14 1440
	;;
esac

exit 0
