#! /bin/sh
# PReP Boot Builder.  Copyright 1999, Matt Porter <porter@debian.org> 
# This is free software under the GNU General Public License.
 
. ./common.sh
 
# Usage message 
if [ $# -lt 3 ]; then
echo "Usage: "$0" archive" 1>&2
        cat 1>&2 << EOF
 
        archive: the directory containing the Debian binary packages.
	top: top of the boot-floppies source tree
	kver: kernel version
EOF
 
        exit -1
fi                                                                  

# Set this to the location of the package archive.
archive=$1

# Set this to the location of the top of the source tree.
top=$2

# Set this to the kernel version
kver=$3

#-----------------------------------------------
# build PReP bootable images
#-----------------------------------------------

# Create a tmp directory
builddir=${tmpdir}/boot-floppies/bootprep-tmp-$$
rm -rf $builddir
make_tmpdir $builddir

# Extract kernel source and patches 
dpkg --extract `ls -t {$top/updates,$archive/devel}/kernel-source-$kver*.deb \
 2>/dev/null | head -1` $builddir
dpkg --extract `ls -t {$top/updates,$archive/devel}/kernel-patch-$kver-powerpc*.deb \
 2>/dev/null | head -1` $builddir

# Unpack kernel source 
cd $builddir/usr/src
if [ -f kernel-source-${kver}.tar.gz ]; then
  tar zxf kernel-source-$kver.tar.gz
else
  tar Ixf kernel-source-$kver.tar.bz2
fi

# Patch kernel source - FIXME: allow for other patches
cd kernel-source-$kver
zcat $builddir/usr/src/kernel-patches/powerpc/*.diff.gz \
 | patch -l -s -p1

# Add rootprep.bin as the ramdisk
cp $top/rootprep.bin ./arch/ppc/coffboot/ramdisk.image.gz 

# Fix .config for ramdisk rooting and kernel ip autoconfiguration.
# This image is >1440 KB and is suitable for CD/net booting. 
sed 's:# CONFIG_CMDLINE_BOOL is not set:CONFIG_CMDLINE_BOOL=y \
CONFIG_CMDLINE="root=/dev/ram ip=off":' \
$builddir/usr/src/kernel-patches/powerpc/config.prep > .config.param

# Enable kernel ip autoconfiguration
sed 's:# CONFIG_IP_PNP is not set:CONFIG_IP_PNP=y \
CONFIG_IP_PNP_ENABLE=y \
CONFIG_IP_PNP_DHCP=y \
CONFIG_IP_PNP_BOOTP=y \
CONFIG_IP_PNP_RARP=y:' \
.config.param > .config.ipauto

# Enable nfsroot
sed 's:CONFIG_NFS_FS=y:CONFIG_NFS_FS=y \
CONFIG_ROOT_NFS=y:' \
.config.ipauto > .config
 
# Build CD/net kernel boot image
make oldconfig && make dep && make clean && make zImage.initrd
cp ./arch/ppc/boot/zImage.initrd $top/bootprepfull.bin

# Copy config.prep->.config and fix up for floppy/ramdisk rooting.
# This image is <=1440 KB and is suitable for floppy booting.
sed 's:# CONFIG_CMDLINE_BOOL is not set:CONFIG_CMDLINE_BOOL=y\
CONFIG_CMDLINE="root=/dev/fd0 load_ramdisk=1":' \
$builddir/usr/src/kernel-patches/powerpc/config.prep > .config

# Build floppy-sized kernel boot image
make oldconfig && make zImage
cp ./arch/ppc/boot/zImage $top/bootprep.bin

# Clean up
rm -rf $builddir
