
#include <std.h>

#include <list/colors.h>
#include <parsers/color.h>

#include "acquire.h"
#include "dialogs.h"

#include "wrappers.h"

UniqueWindow::UniqueWindow(int length_y, int length_x, int displacement_y, int displacement_x)
{
	Length_Y = length_y;
	Length_X = length_x;
	Displacement_Y = displacement_y;
	Displacement_X = displacement_x;

	CreateWindows();
	ChangeColor();
	keypad(Body, true);
}

UniqueWindow::~UniqueWindow()
{
	delwin(Body);
	delwin(Title);
}

void UniqueWindow::CreateWindows()
{
	Title = newwin(Length_Y, Length_X, Displacement_Y, Displacement_X);
	Body = derwin(Title, Length_Y - 2, Length_X - 2, 1, 1);

	wborder(Title, 0, 0, 0, 0, 0, 0, 0, 0);

	Extra_Y = 2;
	Extra_X = 2;

	myassert(Body != 0 && Title != 0, "Window creation failed");
}

void UniqueWindow::ChangeColor(int TitlePair = -1, int BodyPair = -1)
{
	if (BodyPair == -1)
		wbkgd(Body, Pair(COLOR_WHITE, COLOR_BLUE));
	else
		wbkgd(Body, BodyPair);

	if (TitlePair == -1)
		wbkgd(Title, Pair(COLOR_BLUE, COLOR_BLUE) | A_BOLD);
	else
		wbkgd(Title, TitlePair);

	wrefresh(Body);
	wrefresh(Title);
}

void UniqueWindow::ChangeTitle(string titlestr)
{
	wattrset(Title, Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);
	mvwprintw(Title, 0, (Length_X - titlestr.length()) / 2, "%s", (char *) titlestr.c_str());
	wrefresh(Title);
}
