
/*
 * This is meant to sort...ummm... the package list?
 */

#include <std.h>
#include <list/screens.h>
#include <func/config.h>
#include <func/apt.h>
#include "sorting.h"

sortorderlist::sortorderlist()
{
	Head = Tail = NULL;
	nodecount = 0;
}

sortorderlist::~sortorderlist()
{
	Flush();
}

void sortorderlist::Push(method_t myMethod)
{
	nodecount += 1;

	if (Head == NULL && Tail == NULL)
	{
		Head = Tail = (Node *) malloc(sizeof(struct Node));
		Tail->next = NULL;
	}
	else
	{
		Tail->next = (Node *) malloc(sizeof(struct Node));
		Tail->next->next = NULL;
		Tail = Tail->next;
	}

	Tail->seqid = nodecount;
	Tail->thismethod = myMethod;
}

void sortorderlist::Insert(SortIterator & S, method_t myMethod)
{
	Node *x, *insertpos = S.Pos;

	if (insertpos == Head)
	{
		x = Head;
		Head = new Node;
		Head->next = x;

		if (insertpos == Tail)
			Tail = Head;

		x = Head;
	}
	else
	{
		for (x = Head; x->next != insertpos; x = x->next);

		Node *y = x->next;

		x->next = new Node;
		x->next->next = y;

		x = x->next;
	}

	x->seqid = 0;
	x->thismethod = myMethod;

	nodecount += 1;

	reorderseqids();
}

void sortorderlist::Pop(void)
{
	struct Node *p;

	nodecount -= 1;

	if (Head == Tail)
	{
		free(Head);
		Head = Tail = NULL;
	}
	else
	{
		for (p = Head; p->next != Tail; p = p->next);
		p->next = p->next->next;
		free(Tail);
		Tail = p;
	}
}

void sortorderlist::remove(SortIterator & S)
{
	Node *p = S.Pos;

	Node *x = NULL;

	if (p == Head && p == Tail)
	{
		Head = Tail = NULL;
		free(p);
		nodecount = 0;
	}
	else if (p == Head)
	{
		x = Head;
		Head = Head->next;
		free(x);
		nodecount -= 1;
	}
	else if (p == Tail)
	{
		for (x = Head; x->next != Tail; x = x->next);
		x->next = x->next->next;
		free(Tail);
		Tail = x;
		nodecount -= 1;
	}
	else
	{
		for (x = Head; x->next != p; x = x->next);
		x->next = x->next->next;
		free(p);
		nodecount -= 1;
	}

	reorderseqids();
}

void sortorderlist::Flush(void)
{
	while (nodecount > 0)
		Pop();
}

int sortorderlist::qsort_handler(const void *a, const void *b)
{
	const pkgCache::Package & A = **(pkgCache::Package **) a;
	const pkgCache::Package & B = **(pkgCache::Package **) b;
	pkgCache::PkgIterator IterA(*Cache, *(pkgCache::Package **) a);
	pkgCache::PkgIterator IterB(*Cache, *(pkgCache::Package **) b);
	pkgCache::VerIterator VerA = (*Cache)[IterA].CandidateVerIter(*Cache);
	pkgCache::VerIterator VerB = (*Cache)[IterB].CandidateVerIter(*Cache);

	SortIterator S;
	SortIterator End = screen->Sorting->ListEnd();

	for (S = screen->Sorting->ListBegin(); S.end() == false; S++)
	{
		if (S == End)
		{
			switch (S.method())
			{
			case None:
				break;

			case Section:
				return strcmp(Cache->StrP + A.Section, Cache->StrP + B.Section);

			case PkgName:
				return strcmp(Cache->StrP + A.Name, Cache->StrP + B.Name);

			case Priority:
				return strcmp(VerA.PriorityType(), VerB.PriorityType());

			case Status:
				if ((*Cache)[IterA].Status < (*Cache)[IterB].Status)
					return -1;
				else if ((*Cache)[IterA].Status > (*Cache)[IterB].Status)
					return 1;
				else
					return 0;

			case Size:
				return VerA->Size > VerB->Size;

			case Instsize:
				return VerA->InstalledSize > VerB->InstalledSize;
			}
		}
		else
		{
			int comparison;

			switch (S.method())
			{
			case None:
				break;

			case Section:
				comparison = strcmp(Cache->StrP + A.Section, Cache->StrP + B.Section);
				if (comparison != 0)
					return comparison;
				break;

			case PkgName:
				comparison = strcmp(Cache->StrP + A.Name, Cache->StrP + B.Name);
				if (comparison != 0)
					return comparison;
				break;

			case Priority:
				comparison = strcmp(VerA.PriorityType(), VerB.PriorityType());

				if (comparison != 0)
/*
						subcomparison = 0;
					else if (strcmp(VerA.PriorityType(), "Important") == 0)
						subcomparison = 1;
					else if (strcmp(VerA.PriorityType(), "Standard") == 0)
						subcomparison = 2;
					else if (strcmp(VerA.PriorityType(), "Optional") == 0)
						subcomparison = 3;
					else if (strcmp(VerA.PriorityType(), "Extra") == 0)
						subcomparison = 4;
					else if (strcmp(VerA.PriorityType(), "Unknown") == 0)
						subcomparison = 5;
*/
					return comparison;
				break;

			case Status:
				if ((*Cache)[IterA].Status < (*Cache)[IterB].Status)
					return -1;
				else if ((*Cache)[IterA].Status > (*Cache)[IterB].Status)
					return 1;
				break;

			case Size:
				if (VerA->Size < VerB->Size)
					return -1;
				else if (VerA->Size > VerB->Size)
					return 1;
				break;

			case Instsize:
				if (VerA->InstalledSize < VerB->InstalledSize)
					return -1;
				else if (VerA->InstalledSize > VerB->InstalledSize)
					return 1;
				break;
			}
		}
	}

	// This shouldn't happen

	return 0;
}

int sortorderlist::prioritycmp(const char *A, const char *B)
{
	return 1;
}

/*
 * Useful for formatting dividers ... [Order of sort methods]
 */
int sortorderlist::FindIncrement(enum sortorderlist::method_t Type)
{
	for (SortIterator S = ListBegin(); S.end() == false; S++)
	{
		if (S.method() == Type)
			return S.seq();
	}

	return -1;
}

/*
 * Useful for formatting dividers ... [Order of sort methods]
 */
bool sortorderlist::Exists(enum sortorderlist::method_t Type)
{
	for (SortIterator S = ListBegin(); S.end() == false; S++)
	{
		if (S.method() == Type)
			return true;
	}

	return false;
}

/*
 * Simple.. count the number of sort methods that divide the package list
 */
int sortorderlist::DividerCount()
{
	int I = 0;

	for (SortIterator S = ListBegin(); S.end() == false; S++)
	{
		if (S.method() == Status || S.method() == Section || S.method() == Priority)
			I++;
	}

	return I;
}

void sortorderlist::reorderseqids()
{
	int I;
	SortIterator S;

	for (I = 1, S = ListBegin(); S.end() == false; S++, I++)
		S.Pos->seqid = I;
}

void sortorderlist::commit_to_config()
{
	string s;
	char buf[50];

	for (SortIterator S = ListBegin(); S.end() == false; S++)
	{
		sprintf(buf, "%d", S.method());
		s += buf;
		s += "/";
	}

	if (nodecount > 0)
		s.resize(s.size() - 1);
	else
		s = "NULL";

	set_config_string("sort", (char *) s.c_str());
}

void sortorderlist::copy_from_config()
{
	Flush();

	char *tmpbuf = strdup(get_config_string("sort"));

	if (strcmp(tmpbuf, "NULL") != 0)
		for (char *p = strtok(tmpbuf, "/"); p != NULL; p = strtok(NULL, "/"))
			Push((sortorderlist::method_t) atoi(p));

	free(tmpbuf);
}

sortorderlist::SortIterator * sortorderlist::ListFind(method_t ThisMethod)
{
	SortIterator *S = new SortIterator(ListBegin());

	for (; S->end() == false; (*S)++)
		if (S->method() == ThisMethod)
			return S;

	return NULL;
}
