/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "filter.h"
#include "gps.h"

extern gint have_filter;
extern struct filter_info fi_work,fi_stru;
extern gchar col_title[10][10];

GtkWidget *filter_dlg,*lf1,*lf2;

void clear_filter (GtkWidget * widget, gpointer data) {
  have_filter=FALSE;
  refresh();
}

void set_filter_dialog (GtkWidget * widget, gpointer data) {
  GtkWidget *dlg,*v1,*t1,*h1;
  GtkWidget *b[10],*h2,*cb[3],*h3,*h4,*l3,*s1,*ok,*can,*h5;
  static GtkWidget *l1,*l2,*e1;
  static int acoxambre[10]={0,1,2,3,4,5,6,7,8,9};
  int i,j;
  char buffer[5][64];

  memcpy(&fi_stru,&fi_work,sizeof(struct filter_info));

  dlg=gtk_window_new(GTK_WINDOW_DIALOG);
  filter_dlg=dlg;

  v1=gtk_vbox_new(FALSE,2);
  gtk_container_add(GTK_CONTAINER(dlg),v1);
  gtk_window_set_title(GTK_WINDOW(dlg),"Set Filter");
  gtk_container_set_border_width(GTK_CONTAINER(dlg),6);
  GTK_WINDOW(dlg)->position=GTK_WIN_POS_CENTER;
  gtk_widget_show(dlg);

  h1=gtk_hbox_new(FALSE,0);

  sprintf(buffer[0],"Field to filter: %s",col_title[fi_stru.field]);
  
  l1=gtk_label_new(buffer[0]);
  t1=gtk_table_new(2,5,TRUE);
  gtk_box_pack_start(GTK_BOX(v1),h1,FALSE,FALSE,2);
  gtk_box_pack_start(GTK_BOX(h1),l1,FALSE,FALSE,2);
  gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(v1),t1,FALSE,TRUE,2);

  for(i=0;i<10;i++)
    b[i]=gtk_button_new_with_label(col_title[i]);

  for(i=0;i<5;i++) {
    gtk_table_attach_defaults(GTK_TABLE(t1),b[i],i,i+1,0,1);
    gtk_table_attach_defaults(GTK_TABLE(t1),b[i+5],i,i+1,1,2);
    gtk_widget_show(b[i]);
    gtk_widget_show(b[i+5]);
  }

  strcpy(buffer[1],"Processes to show: ");
  switch(fi_stru.cmp) {
  case -1:
    strcat(buffer[1],"Lesser");
    break;
  case 0:
    strcat(buffer[1],"Equal");
    break;
  default:
    strcat(buffer[1],"Greater");
    break;
  }
  l2=gtk_label_new(buffer[1]);

  h2=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(v1),h2,FALSE,TRUE,2);
  gtk_label_set_justify(GTK_LABEL(l2),GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(h2),l2,FALSE,TRUE,2);

  cb[0]=gtk_button_new_with_label("Lesser");
  cb[1]=gtk_button_new_with_label("Equal");
  cb[2]=gtk_button_new_with_label("Greater");

  h3=gtk_hbox_new(TRUE,0);
  gtk_box_pack_start(GTK_BOX(v1),h3,FALSE,TRUE,2);
  for(i=0;i<3;i++) {
    gtk_box_pack_start(GTK_BOX(h3),cb[i],FALSE,TRUE,0);
    gtk_widget_show(cb[i]);
  }

  l3=gtk_label_new("Value for comparison:");
  h4=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(v1),h4,FALSE,TRUE,2);
  gtk_label_set_justify(GTK_LABEL(l3),GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(h4),l3,FALSE,TRUE,2);

  e1=gtk_entry_new_with_max_length(30);
  gtk_entry_set_text(GTK_ENTRY(e1),fi_stru.value);
  gtk_entry_set_editable(GTK_ENTRY(e1),TRUE);
  gtk_box_pack_start(GTK_BOX(v1),e1,FALSE,TRUE,4);

  s1=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v1),s1,FALSE,TRUE,4);

  h5=gtk_hbox_new(TRUE,6);
  ok=gtk_button_new_with_label("Ok");
  can=gtk_button_new_with_label("Cancel");

  gtk_box_pack_start(GTK_BOX(v1),h5,FALSE,TRUE,2);
  gtk_box_pack_end(GTK_BOX(h5),can,TRUE,TRUE,20);
  gtk_box_pack_end(GTK_BOX(h5),ok,TRUE,TRUE,20);

  /*  GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
      gtk_widget_grab_default(ok);*/

  gtk_widget_show(ok);
  gtk_widget_show(can);
  gtk_widget_show(h5);
  gtk_widget_show(s1);
  gtk_widget_show(e1);
  gtk_widget_show(h4);
  gtk_widget_show(l3);
  gtk_widget_show(h3);
  gtk_widget_show(h2);
  gtk_widget_show(l2);
  gtk_widget_show(l1);
  gtk_widget_show(t1);
  gtk_widget_show(h1);
  gtk_widget_show(v1);

  lf1=l1;
  lf2=l2;

  for(i=0;i<10;i++)
    gtk_signal_connect(GTK_OBJECT(b[i]),"clicked",
		       GTK_SIGNAL_FUNC(filter_set_field),(gpointer)(&acoxambre[i]));
  for(i=0;i<3;i++)
    gtk_signal_connect(GTK_OBJECT(cb[i]),"clicked",
		       GTK_SIGNAL_FUNC(filter_set_cmp),(gpointer)(&acoxambre[i]));
  gtk_signal_connect(GTK_OBJECT(ok),"clicked",
		     GTK_SIGNAL_FUNC(filter_set_ok),(gpointer)(e1));  
  gtk_signal_connect(GTK_OBJECT(can),"clicked",
		     GTK_SIGNAL_FUNC(filter_set_cancel),NULL);  
  gtk_grab_add(dlg);
}

void filter_set_field(GtkWidget *gw,gpointer data) {
  int *k;
  static char buffer[64];
  k=(int *)data;
  sprintf(buffer,"Field to filter: %s",col_title[*k]);
  gtk_label_set_text(GTK_LABEL(lf1),buffer);
  fi_stru.field=*k;
}

void filter_set_cmp(GtkWidget *gw,gpointer data) {
  int *k;
  static char buffer[64];
  k=(int *)data;
  strcpy(buffer,"Processes to show: ");
  switch(*k) {
  case 0:
    fi_stru.cmp=-1;
    strcat(buffer,"Lesser");
    break;
  case 1:
    fi_stru.cmp=0;
    strcat(buffer,"Equal");
    break;
  case 2:
    fi_stru.cmp=1;
    strcat(buffer,"Greater");
    break;
  }
  gtk_label_set_text(GTK_LABEL(lf2),buffer);
}

void filter_set_cancel(GtkWidget *gw,gpointer data) {
  gtk_grab_remove(filter_dlg);
  gtk_widget_destroy(filter_dlg);
}

void filter_set_ok(GtkWidget *gw,gpointer data) {
  GtkWidget *e;
  e=(GtkWidget *)data;
  strcpy(fi_stru.value,(char *)(gtk_entry_get_text( GTK_ENTRY(e) )));
  memcpy(&fi_work,&fi_stru,sizeof(struct filter_info));
  have_filter=TRUE;
  gtk_grab_remove(filter_dlg);
  gtk_widget_destroy(filter_dlg);
  refresh();
}
