/* -*-	Mode:C++ -*- */

/*
 * change_tracking.hh
 * Copyright (C) 1999 by John Heidemann
 * $Id: change_tracking.hh,v 1.9 1999/09/06 18:16:16 johnh Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 */


#ifndef lavaps_change_tracking_h
#define lavaps_change_tracking_h

template <class T>
class change_tracking {
protected:
	T last_;
	T change_;
public:
	// gcc won't accept :last_(0)
	// with error ``only constructors take base initializers''
	change_tracking() { last_ = (T)0; }   // xxx: should track whether we're init'ed
	change_tracking(T first) { change_ = last_ = first; }   // the last should be first
	void tick_set(T current) { change_ = T(current - last_); last_ = current; }
	void tick_incr(T delta) { change_ = delta; last_ += delta; }
	void clear_change() { change_ = (T)0; }
	T last() { return last_; }
	T change() { return change_; }
	bool changed() { return change_ != 0; }
};


template <class T, class SUM>
class sum_change_tracking : public change_tracking<T> {
protected:
	static SUM s_;
	void update_sum() { s_.sum_ += change_; }
public:
	sum_change_tracking() {};
	sum_change_tracking(T first) : change_tracking<T>(first) { update_sum(frst); };
	~sum_change_tracking() { tick_incr(-last_); };


	void tick_set(T current) { change_tracking<T>::tick_set(current); update_sum(); };
	void tick_incr(T delta) { change_tracking<T>::tick_incr(delta); update_sum(); };

	T sum() { return s_.sum_; }
};

#endif /* lavaps_change_tracking_h */
