#!/bin/sh
#
# Install a module if a given control file exist
installif(){
	if [ -f $1 ]; then
		echo Configuration file $1 installed: Enabling module $2
		linuxconf --setmod $2
	fi
}
installif /etc/named.boot dnsconf

#
# ip 04.Jan.1998: dnsconf does not work on the sample /etc/named.conf from suse (core dumps while booting)
# installif /etc/named.conf dnsconf
installif /etc/sendmail.cf mailconf
installif /etc/smb.conf samba
installif /etc/httpd/httpd.conf apache
installif /etc/ftpaccess wuftpd
installif /etc/dhcpd.conf dhcpd
installif /usr/bin/fetchmail fetchmailconf
installif /etc/inetd.conf inetdconf


# Install the dialout module all the time
echo Enabling module dialout
linuxconf --setmod dialout
echo Enabling module modemconf
linuxconf --setmod modemconf
echo Enabling module motd
linuxconf --setmod motd
echo Enabling module firewall
linuxconf --setmod firewall
echo Enabling module status
linuxconf --setmod status
echo Enabling treemenu module
linuxconf --setmod treemenu
echo Enabling module inittab
linuxconf --setmod inittab
echo Enabling module managerpm
linuxconf --setmod managerpm

