#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>
#include <ctype.h>
#include <unistd.h>
#define  Uses_XtIntrinsic
#include "diawxxt.h"
#include "protowx.h"
#include "../diajava/protorev.h"
#include <X11/Intrinsic.h>
#include <netdb.h>
#include <sys/time.h>
#include <netinet/in.h>

FILE *ftty = NULL;


class ICON_XPM{
public:
	wxBitmap *bitmap;
	ICON_XPM *next;
	char *name;
	/*~PROTOBEG~ ICON_XPM */
public:
	ICON_XPM (char **tbstr,
		 int nbstr,
		 const char *_name);
	void donothing (void);
	/*~PROTOEND~ ICON_XPM */
};

static ICON_XPM *first=NULL;

static int mform_fdin;
FILE *mform_fout;

PUBLIC ICON_XPM::ICON_XPM(char **tbstr, int nbstr, const char *_name)
{
	/*
		We receive the full content of an XPM file. We must
		strip it somewhat so wxBitmap will use it as if it was
		compiled in the source.
	*/
	next = first;
	first = this;
	char *tb[nbstr];
	int line = 0;
	for (int i=0; i<nbstr; i++){
		char *pt = tbstr[i];
		if (pt[0] == '"'){
			int len = strlen(pt);
			if (len > 0) pt[len-2] = '\0'; 	// Kill ", sequence at the end
			tb[line++] = pt + 1;	// Skip the " at the beginning
		}
	}
	bitmap = new wxBitmap (tb);
	name = strdup(_name);
}

/*
	Just so the compiler shut off
*/
PUBLIC void ICON_XPM::donothing()
{
}

static ICON_XPM *icon_xpm_locate(const char *name)
{
	ICON_XPM *x = first;
	while (x != NULL){
		if (strcmp(x->name,name)==0){
			break;
		}
		x = x->next;
	}
	if (x == NULL) fprintf (stderr,"Unknown XPM icon %s\n",name);
	return x;
}
class MFORMSCRIPT_CTX{
public:
	MFORM *tbfl[20];
	BOOK  *tbbk[20];
	int level;
	SETVAL_INFO info;
	/*~PROTOBEG~ MFORMSCRIPT_CTX */
public:
	MFORMSCRIPT_CTX (void);
	void newlevel (MFORM *fl, BOOK *bk);
	void poplevel (void);
	/*~PROTOEND~ MFORMSCRIPT_CTX */
};

class MFORMSCRIPT{
public:
	char buflines[10000];
	int curlen;
	MAINFORM **tbmain;
	int maxmain;
	bool must_exit;
	char **tbstr;
	int nbstr;
	wxCursor *current;
	/*~PROTOBEG~ MFORMSCRIPT */
public:
	MFORMSCRIPT (bool _must_exit);
	MAINFORM *locate (const char *f);
private:
	bool oneline (char *buf, MFORMSCRIPT_CTX&ctx);
	bool processbuf (bool firstmain);
public:
	void readfromstdin (void);
	void readone (void);
	void run (void);
private:
	void setcontext (MFORMSCRIPT_CTX&ctx,
		 const char *id);
public:
	void setcursor (wxCursor *cur);
	/*~PROTOEND~ MFORMSCRIPT */
};

PUBLIC MFORMSCRIPT::MFORMSCRIPT (bool _must_exit)
{
	buflines[0] = '\0';
	curlen = 0;
	// Obtient la dfinition 
	must_exit = _must_exit;
	maxmain = 100;
	tbmain = new MAINFORM*[100];
	for (int i=0; i<maxmain; i++) tbmain[i] = NULL;
	tbstr = new char *[200];
	nbstr = 0;
	current = NULL;
}
PUBLIC void MFORMSCRIPT::run()
{
	readfromstdin();
	// fprintf (stderr,"End of run\n");
}

// Locate a form using its name ID
PUBLIC MAINFORM *MFORMSCRIPT::locate (const char *f)
{
	MAINFORM *ret = NULL;
	for (int i=0; i<maxmain; i++){
		MAINFORM *mf = tbmain[i];
		if (mf != NULL && strcmp(mf->id,f)==0){
			ret = mf;
			break;
		}
	}
	if (ret == NULL && ftty != NULL){
		fprintf (ftty,"Can't locate form %s\n",f);
	}
	return ret;
}

PUBLIC void MFORMSCRIPT::setcursor(wxCursor *cur)
{
	if (current != cur){
		current = cur;
		for (int i=0; i<maxmain; i++){
			MAINFORM *mf = tbmain[i];
			if (mf != NULL) mf->setcursor (cur);
		}
	}
}

static MAINFORM *remadmin_showerror (const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	char buf[1000];
	vsnprintf (buf,sizeof(buf)-1,ctl,list);
	MAINFORM *msg = new MAINFORM("");
	msg->New_label (buf);
	va_end (list);
	msg->Newline();
	FORMBUTTON *gr = new FORMBUTTON(msg,"but",0);
	msg->New_form(gr);
	gr->New_button ("badver",false,"quit");
	msg->Popup();
	return msg;
}


PUBLIC MFORMSCRIPT_CTX::MFORMSCRIPT_CTX()
{
	level = -1;
	info.tarea = NULL;
}

PUBLIC void MFORMSCRIPT_CTX::newlevel (MFORM *fl, BOOK *bk)
{
	++level;
	tbfl[level] = fl;
	tbbk[level] = bk;
}
PUBLIC void MFORMSCRIPT_CTX::poplevel ()
{
	level--;
	if (level < -1){
		remadmin_showerror ("poplevel %d (Too many End ?)\n",level);
		level = -1;
	}
}

static bool pref_modal=false;
static bool pref_nogfx=false;
static bool pref_html=false;
static bool pref_notree=false;

static const char GCONTENT[]="--gcontent--";

/*
	Set the context to the form or book pointed by ID
*/
PRIVATE void MFORMSCRIPT::setcontext (
	MFORMSCRIPT_CTX &ctx,
	const char *id)
{
	char mainf[strlen(id)+1];
	strcpy (mainf,id);
	char *pt = mainf;
	FORMBASE *parent = NULL;
	while (pt != NULL){
		char *start = pt;
		pt = strchr(start,'.');
		if (pt != NULL){
			*pt++ = '\0';
		}
		BOOK *book = NULL;
		MFORM *form = NULL;
		if (parent != NULL){
			parent->locate(start,form,book);
		}else{
			form = locate (start);
		}
		// fprintf (stderr,"start :%s: %p %p\n",start,form,book);
		if (form != NULL){
			if (form->nbc == 1){
				// Special case from Groups, see GCONTENT
				MFORM_C *c = form->tbc[0];
				if (c->type == T_FORM){
					MFORM *sub = (MFORM*)c->c;
					if (strcmp(sub->id,GCONTENT)==0){
						form->resetlayout();
						form=sub;
					}
				}
			}
			form->resetlayout();
			parent = form;
		}else if (book != NULL){
			book->resetlayout();
			parent = book;
		}else{
			break;
		}
		if (pt == NULL){
			ctx.newlevel (form,book);
		}
	}
}

// Process one line
// Return true if this was a End statement
PRIVATE bool MFORMSCRIPT::oneline(char *buf, MFORMSCRIPT_CTX &ctx)
{
	static bool do_nothing = false;
	if (do_nothing) return false;
	MFORM *fl = NULL;
	BOOK *bk = NULL;
	static bool html_collect = false;	// Collecting an html page
	static int tree_collect = 0;	// Collecting a tree menu
	if (ctx.level >= 0){
		fl = ctx.tbfl[ctx.level];
		bk = ctx.tbbk[ctx.level];
	}
	// fprintf (stderr,"level %d %p %p\n",ctx.level,fl,bk);
	bool end = false;
	if (buf[0] == '\0') return false;
	char args[20][1000];
	const char *ptargs[20];
	int nbargs = 0;
	{
		for (int i=0; i<20; i++){
			args[i][0] = '\0';
			ptargs[i] = args[i];
		}
		char *pt = str_skip(buf);
		if (pt[0]=='#') return false;
		while (*pt != '\0'){
			pt = str_skip(pt);
			if (*pt == '"'){
				pt++;
				char *dst = args[nbargs++];
				while (*pt != '"' && *pt != '\0'){
					if (*pt == '\\'){
						pt++;
					}
					*dst++ = *pt++;
				}
				*dst = '\0';
				if (*pt == '"') pt++;
			}else if (*pt > ' '){
				pt = str_copyword (args[nbargs],pt,sizeof(args[nbargs]));
				nbargs++;
			}
		}
	}
	char *verb = args[0];
	int num=0;
	// The protocol is both ascii and numeric. This allow
	// simple test case to be written
	// The numeric protocol is normally used
	if (isdigit(verb[0])){
		num = atoi(verb);
	}else{
		for (int i=0; i<PROTO_last; i++){
			if (stricmp(verb,protostr[i])==0){
				num = i+1;
				break;
			}
		}
	}
	if (num == PROTO_Str){
		if (html_collect){
		}else if (ctx.info.tarea != NULL){
			const char *cur = ctx.info.tarea->GetValue();
			int len1 = strlen(cur);
			int len2 = strlen(args[1]);
			char tmp[len1+len2+2];
			strcpy (tmp,cur);
			strcpy (tmp+len1,args[1]);
			strcpy (tmp+len1+len2,"\n");
			ctx.info.tarea->SetValue (tmp);
		}else{
			tbstr[nbstr++] = strdup(args[1]);
		}
		return false;
	}
	if (ftty != NULL){
		fprintf (ftty,"oneline :%s: level %d\n",buf,ctx.level);
		fflush (ftty);
	}
	switch (num){
	case PROTO_Version:
		if (atoi(args[1])!=PROTOGUI_REV){
			MAINFORM *msg = remadmin_showerror("%s",args[1]);
			do_nothing = true;
			tbmain[0] = msg;
			ctx.level = -1;
			end = true;
		}
		break;
	case PROTO_Newline:
		fl->Newline();
		break;
	case PROTO_Skip:
		fl->Skip (atoi(args[1]));
		break;
	case PROTO_Fill:
		fl->Fill ();
		break;
	case PROTO_Hline:
		fl->New_hline (args[1]);
		break;
	case PROTO_Dispolast:
		fl->Dispolast (args[1][0]
			,atoi(args[2])
			,args[3][0]
			,atoi(args[4]));
		break;
	case PROTO_Setweightlast:
		fl->Setweightlast (atoi(args[1]),atoi(args[2]));
		break;
	case PROTO_Label:
		fl->New_label (args[1]);
		break;
	case PROTO_Richtext:
		fl->New_richtext (args[1]);
		break;
	case PROTO_String:
		fl->New_string (args[1],atoi(args[2]),args[3]);
		break;
	case PROTO_Password:
		fl->New_password (args[1],atoi(args[2]));
		break;
	case PROTO_Checkbox:
		fl->New_checkbox (args[1],atoi(args[2])!=0,args[3]);
		break;
	case PROTO_Radio:
		fl->New_radio (args[1],atoi(args[2]),atoi(args[3])!=0
			,args[4]);
		break;
	case PROTO_Button:
		fl->New_button (args[1],atoi(args[2])!=0,args[3]);
		break;
	case PROTO_Buttonfill:
		fl->New_buttonfill (args[1],args[2]);
		break;
	case PROTO_Button_xpmf:
		//janne.New_button (fl,ex.nextword(),ex.nextword(),ex.getendskip());
		break;
	case PROTO_Button_xpm:
		{
			ICON_XPM *x = icon_xpm_locate(args[2]);
			if (x != NULL){
				fl->New_button (args[1],x->bitmap);
			}
		}
		break;
	case PROTO_Enteraction:
		fl->gettop()->setenteraction(args[1]);
		break;
	case PROTO_Curfield:
		{
			MAINFORM *mf = locate (args[1]);
			if (mf != NULL){
				wxWindow *tbfocus[20];
				int nbfocus = 0;
				mf->setcurfield (args[2],tbfocus,nbfocus);
				for (int f=nbfocus-1; f>=0; f--) tbfocus[f]->SetFocus();
			}
		}
		break;
	case PROTO_Alive:
		setcursor (cursor_normal);
		break;
	case PROTO_Icon_xpm:
		{
			ICON_XPM *x = icon_xpm_locate(args[1]);
			if (x != NULL){
				fl->New_icon_xpm (x->bitmap);
			}
		}
		break;
	case PROTO_Xfer_xpm:
		{
			ICON_XPM *x = new ICON_XPM (tbstr,nbstr,args[1]);
			x->donothing();
		}
		break;
	case PROTO_Choice:
		fl->New_choice (args[1],args[2]);
		break;
	case PROTO_Choice_item:
		fl->New_choice_item (args[1],args[2],args[3]);
		break;
	case PROTO_List:
		fl->New_list (args[1],atoi(args[2]),args[3]);
		break;
	case PROTO_List_item:
		fl->New_list_item (args[1],args[2]);
		break;
	case PROTO_Combo:
		fl->New_combo (args[1],atoi(args[2]),args[3]);
		break;
	case PROTO_Combo_item:
		fl->New_combo_item (args[1],args[2],args[3]);
		break;
	case PROTO_Group:
		{
			GROUP *gr = new GROUP(fl,args[1],args[2]);
			fl->New_form(gr);
			// We "protecte" the group by creating a subform in which
			// we place the various widgets
			MFORM *sub = gr->New_form(GCONTENT);
			ctx.newlevel (sub,NULL);
		}
		break;
	case PROTO_Groupfit:
		{
			GROUP *gr = new GROUP_FIT(fl,args[1],args[2]);
			fl->New_form(gr);
			MFORM *sub = gr->New_form(GCONTENT);
			ctx.newlevel (sub,NULL);
		}
		break;
	case PROTO_Formbutton:
		{
			FORMBUTTON *gr = new FORMBUTTON(fl,args[1],0);
			fl->New_form(gr);
			ctx.newlevel (gr,NULL);
		}
		break;
	case PROTO_Setcontext:
		setcontext (ctx,args[1]);
		break;
	case PROTO_Form:
		{
			const char *id = args[1];
			if (fl == NULL){
				remadmin_showerror ("A MainForm must be defined first : %s",id);
			}else{
				MFORM *gr = new MFORM(fl,id);
				fl->New_form(gr);
				ctx.newlevel (gr,NULL);
				// fprintf (stderr,"Ctx level %d\n",ctx.level);
			}
		}
		break;
	case PROTO_Clist:
		fl->New_clist(args[1],atoi(args[2]),ptargs+3);
		break;
	case PROTO_Clist_item:
		fl->New_clist_item (args[1],args[2],ptargs+3);
		break;
	case PROTO_Sheet:
		fl->New_sheet (args[1],atoi(args[2]),ptargs+3);
		break;
	case PROTO_Sheet_item:
		fl->New_sheet_item (args[1],atoi(args[2]),atoi(args[3]),args[4]);
		break;
	case PROTO_Treemenu:
		{
			MFORM *gr = new TREEMENU(fl,args[1]);
			fl->New_form(gr);
			ctx.newlevel (gr,NULL);
		}
		break;
	case PROTO_Treeelem:
		((TREEMENU*)fl)->addelm (args[1],args[2]);
		break;
	case PROTO_Treesub:
		((TREEMENU*)fl)->addsub (atoi(args[1]),args[2],args[3]);
		tree_collect++;
		break;
	case PROTO_Page:
		{
			const char *id = args[1];
			if (bk == NULL){
				remadmin_showerror ("A book must be defined first : %s",id);
			}else{
				MFORM *gr = new MFORM(bk,id);
				bk->New_page(gr,args[2]);
				ctx.newlevel (gr,NULL);
			}
		}
		break;
	case PROTO_Book:
		{
			BOOK *b = new BOOK(fl,args[1]);
			fl->New_book(b);
			ctx.newlevel (NULL,b);
		}
		break;
	case PROTO_MainForm:
		{
			const char *id = args[1];
			if (fl != NULL){
				MFORM *gr;
				BOOK *dummy;
				fl->locate (id,gr,dummy);
				if (gr == NULL){
					gr = new MFORM(fl,id);
					fl->New_form(gr);
				}else{
					gr->delall();
				}
				gr->logicaltop = true;
				ctx.newlevel (gr,NULL);
			}else if (bk != NULL){
				MFORM *gr;
				BOOK *dummy;
				bk->locate (id,gr,dummy);
				if (gr == NULL){
					gr = new MFORM(bk,id);
					bk->New_page(gr,args[2]);
				}else{
					gr->delall();
				}
				bk->selpage (gr);
				gr->logicaltop = true;
				ctx.newlevel (gr,NULL);
			}else{
				MAINFORM *gr = NULL;
				for (int i=0; i<maxmain; i++){
					if (tbmain[i] != NULL){
						if (strcmp(tbmain[i]->id,id)==0){
							gr = tbmain[i];
							gr->delall();
							break;
						}
					}
				}
				if (gr == NULL){
					gr = new MAINFORM(args[1],args[2],args[3]);
					for (int i=0; i<maxmain; i++){
						if (tbmain[i] == NULL){
							tbmain[i] = gr;
							break;
						}
					}
				}
				ctx.newlevel (gr,NULL);
			}
		}
		break;
	case PROTO_End:
		if (ctx.info.tarea != NULL){
			ctx.info.tarea = NULL;
		}else if (html_collect){
			html_collect = false;
		}else if (tree_collect){
			((TREEMENU*)fl)->endsub ();
			tree_collect--;
		}else{
			if (ctx.level == 0){
				// Normally, this is always the end of a mainform
				// except for a setcontext, where it can be then end of
				// a sub-form or a book
				if (fl != NULL){
					fl->gettop()->Popup();
				}else if (bk != NULL){
					bk->gettop()->Popup();
				}
			}
			ctx.poplevel();
			end = true;
		}
		break;
	case PROTO_Delete:
		{
			const char *id = args[1];
			if (strchr(id,'.')!=NULL){
				setcontext (ctx,id);
				if (ctx.level >= 0){
					MFORM *fl = ctx.tbfl[ctx.level];
					FORMBASE *parent = fl->getparent();
					parent->delform (fl);
					ctx.poplevel ();
					parent->gettop()->Popup();
				}
			}else{
				for (int i=0; i<maxmain; i++){
					MAINFORM *mf = tbmain[i];
					if (mf != NULL && strcmp(mf->id,id)==0){
						if (i != 0){
							delete mf->getframe();
							tbmain[i] = NULL;
						}else{
							// wxXt exit when the last window
							// is gone. When linuxconf ask for a password
							// it removes the password window and wxXt

							// exit before we have a chance to get in the
							// main screen of linuxconf.
							mf->hide();
						}
						break;
					}
				}
			}
		}
		break;
	case PROTO_Dump:
		{
			MAINFORM *mf = locate(args[1]);
			if (mf != NULL){
				mf->dump();
				fflush (mform_fout);
			}
		}
		break;
	case PROTO_Sidetitle:
		fl->setsidetitle (args[1]);
		break;
	case PROTO_Html:
		html_collect = true;
		break;
	case PROTO_Textarea:
		ctx.info.tarea = fl->New_text (args[1],atoi(args[2]),atoi(args[3]));
		break;
	case PROTO_Slider:
		fl->New_slider (args[1],atoi(args[2]),atoi(args[3]),atoi(args[4])
			,atoi(args[5]));
		break;
	case PROTO_Gauge:
		fl->New_gauge (args[1],atoi(args[2]),atoi(args[3]),atoi(args[4]));
		break;
	case PROTO_Setval:
		{
			int level = ctx.level;
			setcontext (ctx,args[1]);
			if (ctx.level > level){
				FORMBASE *mf = ctx.tbfl[ctx.level];
				if (mf == NULL) mf = ctx.tbbk[ctx.level];
				mf->setval (args[2],(const char **)ptargs+3,ctx.info);
				ctx.poplevel();
			}
		}	
		break;
	case 500:
		// Error reported by linuxconf when connecting to port 98
		{
			MAINFORM *msg = remadmin_showerror(buf);
			do_nothing = true;
			tbmain[0] = msg;
			ctx.level = -1;
			end = true;
		}
		break;
	default:
		fprintf (stderr,"Unknown command %s\n",verb);
	}
	for (int i=0; i<nbstr; i++) free (tbstr[i]);
	nbstr = 0;
	return end;
}
static MFORMSCRIPT_CTX ctx;

/*
	Process all the input.
	Optionnally stop after the first main dialog is built.
	Once this dialog is built, control may be returned to wxXt so
	and the Xt toolkit will call the readone() function everytime
	there is new input.
*/
PRIVATE bool MFORMSCRIPT::processbuf(bool firstmain)
{
	bool done = false;
	buflines[curlen] = '\0';
	char *pt;
	char *ptbuf = buflines;
	while ((pt = strchr(ptbuf,'\n'))!=NULL){
		*pt++ = '\0';
		char *start = ptbuf;
		ptbuf = pt;
		if (oneline (start,ctx)
			&& ctx.level == -1
			&& firstmain){
			done = true;
			break;
		}
	}
	if (ptbuf > buflines){
		int more = curlen - (int)(ptbuf-buflines);
		if (more > 0){
			memmove (buflines,ptbuf,more);
			curlen = more;
		}else{
			curlen = 0;
		}
		buflines[curlen] = '\0';
	}
	//fprintf (ftty,"processbuf curlen = %d\n",curlen);
	//fflush (ftty);
	return done;
}

PUBLIC void MFORMSCRIPT::readfromstdin()
{
	// Process the first MainForm
	while (1){
		int n = read (mform_fdin,buflines+curlen,sizeof(buflines)-1-curlen);
		if (n <= 0) break;
		curlen += n;
		if (processbuf(true)) break;
	}
	// Process the rest of the buffer
	// and let Xt handle the rest
	processbuf(false);
}

static XtInputId xtid;

PUBLIC void MFORMSCRIPT::readone()
{
	int n = read (mform_fdin,buflines+curlen,sizeof(buflines)-1-curlen);
	if (ftty != NULL){
		fprintf (ftty,"readone curlen = %d n = %d\n",curlen,n);
		fflush (ftty);
	}
	if (n > 0){
		curlen += n;
		processbuf(false);
	}else{
		XtRemoveInput(xtid);
		if (must_exit) exit(0);
	}
	if (ftty != NULL){
		fprintf (ftty,"readone end curlen = %d\n",curlen);
		fflush (ftty);
	}
}

class MyApp: public wxApp{
public:
	wxFrame *OnInit(void);
	Bool OnCharHook(wxKeyEvent& event);
};

Bool MyApp::OnCharHook(wxKeyEvent&)
{
	printf ("OnCharHook\n");
	return FALSE;
}
	


static MFORMSCRIPT *sc;

void remadmin_setcursor (wxCursor *cur)
{
	sc->setcursor (cur);
}


static Bool mformscript_readone (XtPointer , int *, XtInputId *)
{
	sc->readone();
	return 1;
}
/*
	Translate an IP number (ascii) into four number
	Return -1 if the IP number is invalid.
*/
static int ipnum_aip24 (const char *aip, int num4[4])
{
	int ret = 0;
	for (int i=0; i<4; i++){
		if (!isdigit(aip[0])){
			ret = -1;
			break;
		}else{
			int no = num4[i] = atoi(aip);
			if (no < 0 || no > 255) ret = -1;
			while (isdigit(*aip)) aip++;
			if (i < 3){
				if (*aip != '.'){
					ret = -1;
					break;
				}
				aip++;
			}
		}
	}
	if (*aip != '\0' && !isspace(*aip)) ret = -1;
	return ret;
}

/*
	Check is a string is valid IP number.
	if (ishost), check if the IP is not a broadcast or a network address.
*/
static bool ipnum_validip(const char *aip, bool ishost)
{
	int num4[4];
	bool ret = false;
	if (ipnum_aip24(aip,num4) != -1){
		ret = true;
		if (ishost && (num4[3] == 0 || num4[3] == 255)){
			ret = false;
		}
	}
	return ret;
}

/*
	Compute an IP number from a string.
*/
static unsigned long ipnum_aip2l (const char *aip)
{
	unsigned long ret = 0xffffffffl;
	int n[4];
	if (ipnum_aip24(aip,n) != -1){
		ret = (n[0] << 24) + (n[1] << 16) + (n[2] << 8) + n[3];
	}
	return ret;
}


static int cmdsock_sinconnect (struct sockaddr_in &sin, int nbretry)
{
	int ret = -1;
	for (int i=0; i<nbretry; i++){		
		int s;
		if ((s = socket (AF_INET, SOCK_STREAM, 0)) >= 0) {
			if (connect (s, (struct sockaddr *) &sin, sizeof (sin))
				== -1){
				close (s);
				sleep(1);
			}else{
				ret = s;
				break;
			}
		}
	}
	return ret;
}

/*
	Establish a socket with a server
	Return -1 if any error.
*/
static int cmdsock_connect (
	const char *servname,
	int port,
	int nbretry,
	char *errorstr)
{
	int ret = -1;
	struct sockaddr_in sin;
	sin.sin_family = AF_INET;
	sin.sin_port = htons(port);
	errorstr[0] = '\0';
	if (ipnum_validip (servname,true)){
		long addr = htonl(ipnum_aip2l (servname));
		memcpy  (&sin.sin_addr,&addr, sizeof(addr));
		ret = cmdsock_sinconnect (sin,nbretry);
	}else{
		struct hostent	*h = (struct hostent *) gethostbyname(servname);
		if (h == NULL){
			sprintf (errorstr,"No server \"%s\" defined",servname);
		}else{
			memcpy  (&sin.sin_addr,h->h_addr, h->h_length);
			ret = cmdsock_sinconnect (sin,nbretry);
		}
	}
	return ret;
}

static wxFrame *startup()
{
	//fprintf (stderr,"Start\n");
	// Send our preference
	fprintf (mform_fout,"prefer %s %s %s %s reconfdia slider gauge setval alive context\n"
		,pref_modal ? "modal" : ""
		,pref_nogfx ? "nogfx" : ""
		,pref_notree ? "" : "treemenu"
		,pref_html ? "html" : "");
	fflush (mform_fout);
	sc = new MFORMSCRIPT (true);
	sc->run();
	xtid = XtAppAddInput (wxAPP_CONTEXT, mform_fdin
				, (XtPointer *) XtInputReadMask
				, (XtInputCallbackProc) mformscript_readone
				, (XtPointer) NULL);

	wxFrame *ret = NULL;
	if (sc->tbmain[0] != NULL){
		ret = sc->tbmain[0]->getframe();
	}
	return ret;
}
static wxFrame *remadmin_usage()
{
	static const char *tb[]={
		"Remote admin front-end for Linuxconf " PACKAGE_REV
		"",
		"Usage:",
		" ",
		"    remadmin --pipe",
		"    remadmin --exec command",
		"    remadmin host_to_remote_admin",
		"",
		NULL
	};
	return error (tb);
}

static wxFrame *remadmin_exec (char *argv[])
{
	wxFrame *ret = NULL;
	int tbin[2];
	int tbout[2];
	if (pipe(tbin)!=-1 && pipe(tbout)!=-1){
		if (fork()==0){
			close (tbin[0]);
			close (tbout[1]);
			dup2 (tbin[1],1);
			dup2 (tbout[0],0);
			execvp (argv[0],argv);
			_exit (-1);
		}else{
			close (tbin[1]);
			close (tbout[0]);
			mform_fdin = tbin[0];
			mform_fout = fdopen (tbout[1],"w");
			ret = startup();
			if (ret == NULL){
				char tmp[100];
				sprintf (tmp,"can't execute %s\n",argv[0]);
				const char *tb[]={
					tmp,
					NULL
				};
				ret = error (tb);
			}
		}
	}else{
		const char *tb[]={
			"Missing resources",
			"",
			strerror(errno),
			NULL
		};
		ret = error (tb);
	}
	return ret;
}

/*
	wxxt want a wxFrame to start normal operation.
	We create the frame normally by reading stdin. Once we have
	the frame, we install a callback with Xt and let wxxt process
	normally the other event.
*/
wxFrame *MyApp::OnInit(void)
{
	wxFrame *ret = NULL;
	defs_init();
	//ftty = fopen ("/dev/tty","w");
	int arg;
	for (arg=1; arg<argc; arg++){
		const char *pt = argv[arg];
		if (strcmp(pt,"--modal")==0){
			pref_modal = true;
		}else if (strcmp(pt,"--nogfx")==0){
			pref_nogfx = true;
		}else if (strcmp(pt,"--notree")==0){
			pref_notree = true;
		}else if (strcmp(pt,"--html")==0){
			pref_html = true;
		}else{
			break;
		}
	}
	if (arg <= argc -1){
		// Attempt remote connecting to a linuxconf server
		const char *arg1 = argv[arg];
		if (strcmp(arg1,"--pipe")==0){
			if (arg == argc -1){
				mform_fdin = 0;
				mform_fout = stdout;
				ret = startup();
			}else if (arg == argc - 2){
				mform_fdin = atoi(argv[arg+1]);
				mform_fout = fdopen (mform_fdin,"w");
				//ftty = stdout;
				ret = startup();
			}else{
				ret = remadmin_usage();
			}
		}else if (strcmp(arg1,"--exec")==0){
			if (arg == argc - 1){
				ret = remadmin_usage();
			}else{
				ret = remadmin_exec (argv+arg+1);
			}
		}else{
			char errorstr[100];
			int fd = cmdsock_connect (arg1,98,1,errorstr);
			if (fd == -1){
				char tmp[100];
				sprintf (tmp,"Can't connect to server %s",arg1);
				const char *tb[]={tmp,"",errorstr,NULL};
				ret = error (tb);
			}else{
				static char msg[]="get /remadm: http/1.0\n\n";
				mform_fout = fdopen (fd,"w");
				fputs (msg,mform_fout);		// startup() does a fflush()
				mform_fdin = fd;
				ret = startup();
			}
		}
	}else{
		ret = remadmin_usage();
	}
	return ret;
}

MyApp myapp;


