#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include "netconf.h"


PUBLIC THISHOST::THISHOST()
{
	char hostname[200];
	if (netconf_netok(NULL,hostname)){
		name1 = strdup(hostname);
		is_config = 1;
	}else{
		name1 = strdup("");
		is_config = 0;
	}
}
PUBLIC THISHOST::~THISHOST()
{
	free (name1);
	is_config = 0;
}

/*
	Accept a new name for the host.
*/
PUBLIC void THISHOST::setname1(const char *newname1)
{
	free(name1);
	name1 = strdup(newname1);
}

#if 0
/*
	Return of the IP number of this host
*/
PUBLIC const char *THISHOST::getipnum(int )
{
	return ip_num;
}
#endif
/*
	Return of the primary name of this host
*/
PUBLIC const char *THISHOST::getname1()
{
	return name1;
}

/*
	Return the domain part of the host name
*/
PUBLIC const char *THISHOST::getdomain()
{
	const char *ret = NULL;
	const char *pt = strchr (name1,'.');
	if (pt != NULL) ret = pt + 1;
	return ret;
}

/*
	Return != 0 if the local hostname is correctly configured
*/
PUBLIC int THISHOST::configok()
{
	return is_config;
}


#ifdef TEST

int main (int argc, char *argv[])
{
	THISHOST host;
	if (host.configok()){
		printf (":%s: -> :%s:\n",host.getname1(),host.getipnum(0));
	}else{
		printf ("Pas configurer\n");
	}
	return 0;
}

#endif

