#!/bin/sh -e

# Idea borrowed from RedHat's kernel package

if [ -n "$1" ]; then
	if [ ! -d "$1" ]; then
		echo "$1" does not exist, or is not a directory
		exit 1
	fi
	cd $1
else
	cd /usr/include
fi

if [ ! -d asm-sparc -o ! -d asm-sparc64 ] ; then
	echo E: asm-sparc and asm-sparc64 must exist, or you will have problems
	exit 1
fi

rm -rf asm
mkdir asm

for h in `( ls asm-sparc; ls asm-sparc64 ) | grep '\.h$' | sort -u`; do
	name=`echo $h | tr a-z. A-Z_`
	# common header
	cat > asm/$h << EOF
/* All asm/ files are generated and point to the corresponding
 * file in asm-sparc or asm-sparc64. To regenerate, run "generate-asm"
 */

#ifndef __SPARCSTUB__${name}__
#define __SPARCSTUB__${name}__

EOF

	# common for sparc and sparc64
	if [ -f asm-sparc/$h -a -f asm-sparc64/$h ]; then
		cat >> asm/$h <<EOF
#ifdef __arch64__
#include <asm-sparc64/$h>
#else
#include <asm-sparc/$h>
#endif
EOF

	# sparc only
	elif [ -f asm-sparc/$h ]; then
		cat >> asm/$h <<EOF
#ifndef __arch64__
#include <asm-sparc/$h>
#endif
EOF
	# sparc64 only
	else
		cat >> asm/$h <<EOF
#ifdef __arch64__
#include <asm-sparc64/$h>
#endif
EOF
	fi

	# common footer
	cat >> asm/$h <<EOF

#endif /* !__SPARCSTUB__${name}__ */
EOF

done
