------------------------------------------------------------------------------
--                                                                          --
--             ASIS Tester And iNTerpreter (ASIStant) COMPONENTS            --
--                                                                          --
--                      A S I S T A N T . F U N C A R R                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--          Copyright (c) 1997-1999, Free Software Foundation, Inc.         --
--                                                                          --
-- ASIStant is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIStant is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- ASIStant is an evolution of ASIStint tool that was created by            --
-- Vasiliy Fofanov as part of a collaboration between Software Engineering  --
-- Laboratory of the Swiss Federal Institute of Technology in Lausanne,     --
-- Switzerland, and the Scientific Research Computer Center of the Moscow   --
-- University, Russia, supported by the Swiss National Science Foundation   --
-- grant #7SUPJ048247, "Development of ASIS for GNAT with industry quality" --
--                                                                          --
-- ASIStant is distributed as a part of the ASIS implementation for GNAT    --
-- (ASIS-for-GNAT) and is maintained by Ada Core Technologies Inc           --
-- (http ://www.gnat.com).                                                   --
------------------------------------------------------------------------------

with Asis;  use Asis;

with Asis.Ada_Environments;
with Asis.Clauses;
with Asis.Compilation_Units;
with Asis.Compilation_Units.Relations;
with Asis.Data_Decomposition;
with Asis.Declarations;
with Asis.Definitions;
with Asis.Elements;
with Asis.Expressions;
with Asis.Implementation;
with Asis.Implementation.Permissions;
with Asis.Statements;
with Asis.Text;

with ASIStant.Enum_Mapping;

with ASIStant.FuncEnum, ASIStant.FuncTypes;
use  ASIStant.FuncEnum, ASIStant.FuncTypes;

with ASIStant.Add_Ons; use ASIStant.Add_Ons;
with ASIStant.Browser;

package ASIStant.FuncArr is

------------------------------------------------------------------------------
--  Arrays of accesses to ASIS queries
------------------------------------------------------------------------------

   package DDA renames Asis.Data_Decomposition;

   FCtxRetBool : array
     (Exists .. Has_Associations)
       of CtxRetBool :=
   (
     Asis.Ada_Environments.Exists'Access,
     Asis.Ada_Environments.Is_Open'Access,
     Asis.Ada_Environments.Has_Associations'Access
   );


   FCtxRetCUnitList : array
     (Compilation_Unit_Bodies .. Library_Unit_Declarations)
       of CtxRetCUnitList :=
   (
     Asis.Compilation_Units.Compilation_Unit_Bodies'Access,
     Asis.Compilation_Units.Compilation_Units'Access,
     Asis.Compilation_Units.Library_Unit_Declarations'Access
   );


   FCtxRetElemList : array
     (Configuration_Pragmas .. Configuration_Pragmas)
       of CtxRetElemList :=
   (others =>
     Asis.Elements.Configuration_Pragmas'Access
   );


   FCtxRetNull : array
     (Close .. Open)
       of CtxRetNull :=
   (
     Asis.Ada_Environments.Close'Access,
     Asis.Ada_Environments.Dissociate'Access,
     Asis.Ada_Environments.Open'Access
   );


   FCtxRetString : array
     (Debug_Image_Ctx .. Parameters)
       of CtxRetString :=
   (
     Asis.Ada_Environments.Debug_Image'Access,
     Asis.Ada_Environments.Name'Access,
     Asis.Ada_Environments.Parameters'Access
   );


   FCtxStringStringRetNull : array
     (Associate .. Associate)
       of CtxStringStringRetNull :=
   (others =>
     Asis.Ada_Environments.Associate'Access
   );


   FCUnitBoolRetElemList : array
     (Context_Clause_Elements .. Context_Clause_Elements)
       of CUnitBoolRetElemList :=
   (others =>
     Asis.Elements.Context_Clause_Elements'Access
   );


   FCUnitCtxRetCUnit : array
     (Corresponding_Body_CU_Ctx .. Corresponding_Subunit_Parent_Body_Ctx)
       of CUnitCtxRetCUnit :=
   (
     Asis.Compilation_Units.Corresponding_Body'Access,
     Asis.Compilation_Units.Corresponding_Declaration'Access,
     Asis.Compilation_Units.Corresponding_Parent_Declaration'Access,
     Asis.Compilation_Units.Corresponding_Subunit_Parent_Body'Access
   );


   FCUnitCtxRetCUnitList : array
     (Corresponding_Children_Ctx .. Subunits_Ctx)
       of CUnitCtxRetCUnitList :=
   (
     Asis.Compilation_Units.Corresponding_Children'Access,
     Asis.Compilation_Units.Subunits'Access
   );


   FCUnitCUnitRetBool : array
     (Is_Equal_CU .. Is_Identical_CU)
       of CUnitCUnitRetBool :=
   (
     Asis.Compilation_Units.Is_Equal'Access,
     Asis.Compilation_Units.Is_Identical'Access
   );


   FCUnitListRetBool : array
     (Is_Nil_CUL .. Is_Nil_CUL)
       of CUnitListRetBool :=
   (others =>
     Asis.Compilation_Units.Is_Nil'Access
   );


   FCUnitListCtxRetRelship : array
     (Elaboration_Order .. Elaboration_Order)
       of CUnitListCtxRetRelship :=
   (others =>
     Asis.Compilation_Units.Relations.Elaboration_Order'Access
   );

   FCUnitListCUnitListCtxStringRetRelship : array
     (Semantic_Dependence_Order .. Semantic_Dependence_Order)
       of CUnitListCUnitListCtxStringRetRelship :=
   (others =>
      ASIStant.Enum_Mapping.Semantic_Dependence_Order'Access
   );


   FCUnitRetBool : array
     (Can_Be_Main_Program .. Is_Nil_CU)
       of CUnitRetBool :=
   (
     Asis.Compilation_Units.Can_Be_Main_Program'Access,
     Asis.Compilation_Units.Exists'Access,
     Asis.Compilation_Units.Is_Body_Required'Access,
     Asis.Compilation_Units.Is_Nil'Access
   );


   FCUnitRetCtx : array
     (Enclosing_Context .. Enclosing_Context)
       of CUnitRetCtx :=
   (others =>
     Asis.Compilation_Units.Enclosing_Context'Access
   );


   FCUnitRetCUnit : array
     (Corresponding_Body_CU .. Corresponding_Subunit_Parent_Body)
       of CUnitRetCUnit :=
   (
     Asis.Compilation_Units.Corresponding_Body'Access,
     Asis.Compilation_Units.Corresponding_Declaration'Access,
     Asis.Compilation_Units.Corresponding_Parent_Declaration'Access,
     Asis.Compilation_Units.Corresponding_Subunit_Parent_Body'Access
   );


   FCUnitRetCUnitList : array
     (Corresponding_Children .. Subunits)
       of CUnitRetCUnitList :=
   (
     Asis.Compilation_Units.Corresponding_Children'Access,
     Asis.Compilation_Units.Subunits'Access
   );


   FCUnitRetElem : array
     (Unit_Declaration .. Unit_Declaration)
       of CUnitRetElem :=
   (others =>
     Asis.Elements.Unit_Declaration'Access
   );


   FCUnitRetElemList : array
     (Compilation_Pragmas .. Compilation_Pragmas)
       of CUnitRetElemList :=
   (others =>
     Asis.Elements.Compilation_Pragmas'Access
   );


   FCUnitRetString : array
     (Compilation_Command_Line_Options .. Unique_Name)
       of CUnitRetString :=
   (
     Asis.Compilation_Units.Compilation_Command_Line_Options'Access,
     Asis.Compilation_Units.Debug_Image'Access,
     Asis.Compilation_Units.Object_Form'Access,
     Asis.Compilation_Units.Object_Name'Access,
     Asis.Compilation_Units.Text_Form'Access,
     Asis.Compilation_Units.Text_Name'Access,
     ASIStant.Enum_Mapping.Unit_Class'Access,
     Asis.Compilation_Units.Unit_Full_Name'Access,
     ASIStant.Enum_Mapping.Unit_Kind'Access,
     ASIStant.Enum_Mapping.Unit_Origin'Access,
     Asis.Compilation_Units.Unique_Name'Access
   );

   FCUnitStringRetBool : array
     (Has_Attribute .. Has_Attribute)
       of CUnitStringRetBool :=
   (others =>
     Asis.Compilation_Units.Has_Attribute'Access
   );


   FCUnitStringRetString : array
     (Attribute_Values .. Attribute_Values)
       of CUnitStringRetString :=
   (others =>
     Asis.Compilation_Units.Attribute_Values'Access
   );


   FDDA_ArrCRetDDA_ArrC : array
      (DDA_Array_Components_2 .. DDA_Array_Components_2)
         of DDA_ArrCRetDDA_ArrC :=
   (others =>
      DDA.Array_Components'Access
   );


   FDDA_ArrCRetDDA_RecCList : array
      (DDA_Discriminant_Components_2 .. DDA_Record_Components_2)
         of DDA_ArrCRetDDA_RecCList :=
   (
      DDA.Discriminant_Components'Access,
      DDA.Record_Components'Access
   );


   FDDA_ArrCRetElem : array
      (DDA_Component_Indication .. DDA_Component_Indication)
         of DDA_ArrCRetElem :=
   (others =>
      DDA.Component_Indication'Access
   );


   FDDA_RecCRetDDA_ArrC : array
      (DDA_Array_Components_1 .. DDA_Array_Components_1)
         of DDA_RecCRetDDA_ArrC :=
   (others =>
      DDA.Array_Components'Access
   );


   FDDA_RecCRetDDA_RecCList : array
      (DDA_Discriminant_Components_1 .. DDA_Record_Components_1)
         of DDA_RecCRetDDA_RecCList :=
   (
      DDA.Discriminant_Components'Access,
      DDA.Record_Components'Access
   );


   FDDA_RecCRetElem : array
      (DDA_Component_Declaration .. DDA_Component_Declaration)
         of DDA_RecCRetElem :=
   (others =>
      DDA.Component_Declaration'Access
   );


   FElemBoolRetElemList : array
     (Accept_Body_Exception_Handlers .. Visible_Part_Items)
       of ElemBoolRetElemList :=
   (
     Asis.Statements.Accept_Body_Exception_Handlers'Access,
     Asis.Statements.Accept_Body_Statements'Access,
     Asis.Statements.Block_Declarative_Items'Access,
     Asis.Statements.Block_Exception_Handlers'Access,
     Asis.Statements.Block_Statements'Access,
     Asis.Declarations.Body_Declarative_Items'Access,
     Asis.Declarations.Body_Exception_Handlers'Access,
     Asis.Declarations.Body_Statements'Access,
     Asis.Statements.Call_Statement_Parameters'Access,
     Asis.Clauses.Component_Clauses'Access,
     Asis.Definitions.Discriminant_Associations'Access,
     Asis.Expressions.Function_Call_Parameters'Access,
     Asis.Declarations.Generic_Actual_Part'Access,
     Asis.Declarations.Generic_Formal_Part'Access,
     Asis.Statements.Handler_Statements'Access,
     Asis.Statements.Loop_Statements'Access,
     Asis.Declarations.Private_Part_Declarative_Items'Access,
     Asis.Definitions.Private_Part_Items'Access,
     Asis.Declarations.Protected_Operation_Items'Access,
     Asis.Expressions.Record_Component_Associations'Access,
     Asis.Definitions.Record_Components'Access,
     Asis.Statements.Sequence_Of_Statements'Access,
     Asis.Statements.Statement_Paths'Access,
     Asis.Definitions.Variants'Access,
     Asis.Declarations.Visible_Part_Declarative_Items'Access,
     Asis.Definitions.Visible_Part_Items'Access
   );


   FElemCtxRetElem : array
     (Corresponding_Body_Ctx .. Corresponding_Type_Declaration_Ctx)
       of ElemCtxRetElem :=
   (
     Asis.Declarations.Corresponding_Body'Access,
     Asis.Declarations.Corresponding_Body_Stub'Access,
     Asis.Declarations.Corresponding_Declaration'Access,
     Asis.Declarations.Corresponding_Subunit'Access,
     Asis.Declarations.Corresponding_Type_Declaration'Access
   );


   FElemElemBoolRetBool : array
     (Is_Referenced .. Is_Referenced)
       of ElemElemBoolRetBool :=
   (others =>
      Asis.Expressions.Is_Referenced'Access
   );


   FElemElemBoolRetElemList : array
     (References .. References)
       of ElemElemBoolRetElemList :=
   (others =>
      Asis.Expressions.References'Access
   );


   FElemElemRetBool : array
     (Is_Equal .. Is_Identical)
       of ElemElemRetBool :=
   (
      Asis.Elements.Is_Equal'Access,
      Asis.Elements.Is_Identical'Access
   );


   FElemElemRetElem : array
      (Enclosing_Element_EEE .. Enclosing_Element_EEE)
         of ElemElemRetElem :=
   (others =>
      Asis.Elements.Enclosing_Element'Access
   );


   FElemIntIntRetLineList : array
      (Lines_2 .. Lines_2)
         of ElemIntIntRetLineList :=
   (others =>
      Asis.Text.Lines'Access
   );


   FElemListRetBool : array
      (Is_Nil_EL .. Is_Nil_EL)
         of ElemListRetBool :=
   (others =>
      Asis.Elements.Is_Nil'Access
   );


   FElemRetBool : array
     (Declarations_Is_Private_Present .. Is_Text_Available)
       of ElemRetBool :=
   (
     Asis.Declarations.Is_Private_Present'Access,
     Asis.Definitions.Is_Private_Present'Access,
     Asis.Statements.Is_Declare_Block'Access,
     Asis.Expressions.Is_Defaulted_Association'Access,
     Asis.Declarations.Is_Name_Repeated'Access,
     Asis.Statements.Is_Name_Repeated'Access,
     Asis.Elements.Is_Nil'Access,
     Asis.Expressions.Is_Normalized'Access,
     Asis.Elements.Is_Part_Of_Implicit'Access,
     Asis.Elements.Is_Part_Of_Inherited'Access,
     Asis.Elements.Is_Part_Of_Instance'Access,
     Asis.Expressions.Is_Prefix_Call'Access,
     Asis.Declarations.Is_Private_Present'Access,
     Asis.Declarations.Is_Subunit'Access,
     Text.Is_Text_Available'Access
   );


   FElemRetCUnit : array
     (Enclosing_Compilation_Unit .. Enclosing_Compilation_Unit)
       of ElemRetCUnit :=
   (others =>
     Asis.Elements.Enclosing_Compilation_Unit'Access
   );


   FElemRetDDA_ArrC : array
     (DDA_Array_Components .. DDA_Array_Components)
       of ElemRetDDA_ArrC :=
   (others =>
     DDA.Array_Components'Access
   );


   FElemRetDDA_RecCList : array
     (DDA_Record_Components .. DDA_Record_Components)
       of ElemRetDDA_RecCList :=
   (others =>
     DDA.Record_Components'Access
   );


   FElemRetElem  : array
     (Accept_Entry_Direct_Name .. While_Condition)
       of ElemRetElem :=
   (
     Asis.Statements.Accept_Entry_Direct_Name'Access,
     Asis.Statements.Accept_Entry_Index'Access,
     Asis.Definitions.Access_To_Function_Result_Profile'Access,
     Asis.Definitions.Access_To_Object_Definition'Access,
     Asis.Expressions.Actual_Parameter'Access,
     Asis.Expressions.Allocator_Qualified_Expression'Access,
     Asis.Expressions.Allocator_Subtype_Indication'Access,
     Asis.Definitions.Ancestor_Subtype_Indication'Access,
     Asis.Definitions.Array_Component_Definition'Access,
     Asis.Statements.Assignment_Expression'Access,
     Asis.Statements.Assignment_Variable_Name'Access,
     Asis.Expressions.Attribute_Designator_Identifier'Access,
     Asis.Declarations.Body_Block_Statement'Access,
     ASIStant.Browser.Browse'Access,
     Asis.Statements.Called_Name'Access,
     Asis.Statements.Case_Expression'Access,
     Asis.Statements.Choice_Parameter_Specification'Access,
     Asis.Clauses.Component_Clause_Position'Access,
     Asis.Clauses.Component_Clause_Range'Access,
     Asis.Expressions.Component_Expression'Access,
     Asis.Definitions.Component_Subtype_Indication'Access,
     Asis.Statements.Condition_Expression'Access,
     Asis.Expressions.Converted_Or_Qualified_Expression'Access,
     Asis.Expressions.Converted_Or_Qualified_Subtype_Mark'Access,
     Asis.Declarations.Corresponding_Base_Entity'Access,
     Asis.Declarations.Corresponding_Body'Access,
     Asis.Declarations.Corresponding_Body_Stub'Access,
     Asis.Statements.Corresponding_Called_Entity'Access,
     Asis.Expressions.Corresponding_Called_Function'Access,
     Asis.Declarations.Corresponding_Constant_Declaration'Access,
     Asis.Declarations.Corresponding_Declaration'Access,
     Asis.Statements.Corresponding_Destination_Statement'Access,
     Asis.Statements.Corresponding_Entry'Access,
     Asis.Declarations.Corresponding_Equality_Operator'Access,
     Asis.Expressions.Corresponding_Expression_Type'Access,
     Asis.Declarations.Corresponding_First_Subtype'Access,
     Asis.Declarations.Corresponding_Generic_Element'Access,
     Asis.Declarations.Corresponding_Last_Constraint'Access,
     Asis.Declarations.Corresponding_Last_Subtype'Access,
     Asis.Statements.Corresponding_Loop_Exited'Access,
     Asis.Expressions.Corresponding_Name_Declaration'Access,
     Asis.Expressions.Corresponding_Name_Definition'Access,
     Asis.Definitions.Corresponding_Parent_Subtype'Access,
     Asis.Definitions.Corresponding_Root_Type'Access,
     Asis.Declarations.Corresponding_Subprogram_Derivation'Access,
     Asis.Declarations.Corresponding_Subunit'Access,
     Asis.Declarations.Corresponding_Type'Access,
     Asis.Declarations.Corresponding_Type_Declaration'Access,
     Asis.Definitions.Corresponding_Type_Structure'Access,
     Asis.Declarations.Declaration_Subtype_Mark'Access,
     Asis.Declarations.Defining_Prefix'Access,
     Asis.Declarations.Defining_Selector'Access,
     Asis.Statements.Delay_Expression'Access,
     Asis.Definitions.Delta_Expression'Access,
     Asis.Definitions.Digits_Expression'Access,
     Asis.Definitions.Discriminant_Direct_Name'Access,
     Asis.Expressions.Discriminant_Expression'Access,
     Asis.Declarations.Discriminant_Part'Access,
     Asis.Elements.Enclosing_Element'Access,
     Asis.Declarations.Entry_Barrier'Access,
     Asis.Declarations.Entry_Family_Definition'Access,
     Asis.Declarations.Entry_Index_Specification'Access,
     Asis.Statements.Exit_Condition'Access,
     Asis.Statements.Exit_Loop_Name'Access,
     Asis.Expressions.Expression_Parenthesized'Access,
     Asis.Expressions.Extension_Aggregate_Expression'Access,
     Asis.Statements.For_Loop_Parameter_Specification'Access,
     Asis.Expressions.Formal_Parameter'Access,
     Asis.Declarations.Formal_Subprogram_Default'Access,
     Asis.Declarations.Generic_Unit_Name'Access,
     Asis.Statements.Goto_Label'Access,
     Asis.Statements.Guard'Access,
     Asis.Declarations.Initialization_Expression'Access,
     Asis.Definitions.Integer_Constraint'Access,
     Asis.Definitions.Lower_Bound'Access,
     Asis.Expressions.Membership_Test_Expression'Access,
     Asis.Expressions.Membership_Test_Range'Access,
     Asis.Expressions.Membership_Test_Subtype_Mark'Access,
     Asis.Clauses.Mod_Clause_Expression'Access,
     Asis.Definitions.Mod_Static_Expression'Access,
     Asis.Declarations.Object_Declaration_View'Access,
     Asis.Definitions.Parent_Subtype_Indication'Access,
     Asis.Expressions.Prefix'Access,
     Asis.Statements.Qualified_Expression'Access,
     Asis.Statements.Raised_Exception'Access,
     Asis.Definitions.Range_Attribute'Access,
     Asis.Definitions.Real_Range_Constraint'Access,
     Asis.Definitions.Record_Definition'Access,
     Asis.Declarations.Renamed_Entity'Access,
     Asis.Clauses.Representation_Clause_Expression'Access,
     Asis.Clauses.Representation_Clause_Name'Access,
     Asis.Statements.Requeue_Entry_Name'Access,
     Asis.Declarations.Result_Profile'Access,
     Asis.Statements.Return_Expression'Access,
     Asis.Expressions.Selector'Access,
     Asis.Expressions.Short_Circuit_Operation_Left_Expression'Access,
     Asis.Expressions.Short_Circuit_Operation_Right_Expression'Access,
     Asis.Expressions.Slice_Range'Access,
     Asis.Declarations.Specification_Subtype_Definition'Access,
     Asis.Statements.Statement_Identifier'Access,
     Asis.Definitions.Subtype_Constraint'Access,
     Asis.Definitions.Subtype_Mark'Access,
     Asis.Declarations.Type_Declaration_View'Access,
     Asis.Definitions.Upper_Bound'Access,
     Asis.Statements.While_Condition'Access
   );


   FElemRetElemList : array
     (Aborted_Tasks .. Variant_Choices)
       of ElemRetElemList :=
   (
     Asis.Statements.Aborted_Tasks'Access,
     Asis.Statements.Accept_Parameters'Access,
     Asis.Definitions.Access_To_Subprogram_Parameter_Profile'Access,
     Asis.Expressions.Array_Component_Associations'Access,
     Asis.Expressions.Array_Component_Choices'Access,
     Asis.Expressions.Attribute_Designator_Expressions'Access,
     Asis.Statements.Case_Statement_Alternative_Choices'Access,
     Asis.Clauses.Clause_Names'Access,
     Asis.Expressions.Corresponding_Name_Definition_List'Access,
     Asis.Elements.Corresponding_Pragmas'Access,
     Asis.Declarations.Corresponding_Representation_Clauses'Access,
     Asis.Definitions.Corresponding_Type_Operators'Access,
     DDA.All_Named_Components'Access,
     Asis.Definitions.Discrete_Ranges'Access,
     Asis.Definitions.Discrete_Subtype_Definitions'Access,
     Asis.Expressions.Discriminant_Selector_Names'Access,
     Asis.Definitions.Discriminants'Access,
     Asis.Definitions.Enumeration_Literal_Declarations'Access,
     Asis.Statements.Exception_Choices'Access,
     Asis.Definitions.Implicit_Components'Access,
     Asis.Definitions.Implicit_Inherited_Declarations'Access,
     Asis.Definitions.Implicit_Inherited_Subprograms'Access,
     Asis.Expressions.Index_Expressions'Access,
     Asis.Definitions.Index_Subtype_Definitions'Access,
     Asis.Statements.Label_Names'Access,
     Asis.Declarations.Names'Access,
     Asis.Declarations.Parameter_Profile'Access,
     Asis.Elements.Pragma_Argument_Associations'Access,
     Asis.Elements.Pragmas'Access,
     Asis.Expressions.Record_Component_Choices'Access,
     Asis.Definitions.Variant_Choices'Access
   );


   FElemRetInt : array
     (Hash .. Hash)
       of ElemRetInt :=
   (others =>
--  !!!    Text.First_Line_Number'Access,
     Asis.Elements.Hash'Access
--  !!!    Asis.Text.Last_Line_Number'Access
   );

   FElemRetLineList : array
      (Lines .. Lines)
         of ElemRetLineList :=
   (others =>
      Asis.Text.Lines'Access
   );


   FElemRetSpan : array
     (Compilation_Span .. Element_Span)
       of ElemRetSpan :=
   (
     Text.Compilation_Span'Access,
     Text.Compilation_Unit_Span'Access,
     Text.Element_Span'Access
   );


   FElemRetString : array
     (Access_Type_Kind .. Value_Image)
       of ElemRetString :=
   (
     ASIStant.Enum_Mapping.Access_Type_Kind'Access,
     ASIStant.Enum_Mapping.Association_Kind'Access,
     ASIStant.Enum_Mapping.Attribute_Kind'Access,
     ASIStant.Enum_Mapping.Clause_Kind'Access,
     ASIStant.Enum_Mapping.Constraint_Kind'Access,
     Asis.Elements.Debug_Image'Access,
     ASIStant.Enum_Mapping.Declaration_Kind'Access,
     ASIStant.Enum_Mapping.Declaration_Origin'Access,
     ASIStant.Enum_Mapping.Default_Kind'Access,
     Asis.Declarations.Defining_Name_Image'Access,
     ASIStant.Enum_Mapping.Defining_Name_Kind'Access,
     ASIStant.Enum_Mapping.Definition_Kind'Access,
     ASIStant.Enum_Mapping.Discrete_Range_Kind'Access,
     Text.Element_Image'Access,
     ASIStant.Enum_Mapping.Element_Kind'Access,
     ASIStant.Enum_Mapping.Expression_Kind'Access,
     ASIStant.Enum_Mapping.Formal_Type_Kind'Access,
     ASIStant.Enum_Mapping.Mode_Kind'Access,
     Asis.Expressions.Name_Image'Access,
     ASIStant.Enum_Mapping.Operator_Kind'Access,
     ASIStant.Enum_Mapping.Path_Kind'Access,
     Asis.Declarations.Position_Number_Image'Access,
     ASIStant.Enum_Mapping.Pragma_Kind'Access,
     Asis.Elements.Pragma_Name_Image'Access,
     ASIStant.Enum_Mapping.Representation_Clause_Kind'Access,
     Asis.Declarations.Representation_Value_Image'Access,
     ASIStant.Enum_Mapping.Root_Type_Kind'Access,
     ASIStant.Enum_Mapping.Statement_Kind'Access,
     ASIStant.Enum_Mapping.Trait_Kind'Access,
     ASIStant.Enum_Mapping.Type_Kind'Access,
     Asis.Expressions.Value_Image'Access
   );


   FElemSpanRetLineList : array
      (Lines_1 .. Lines_1)
         of ElemSpanRetLineList :=
   (others =>
      Asis.Text.Lines'Access
   );


   FIntIntRetBool : array
     (Eq .. Lt)
       of IntIntRetBool :=
   (
     Eq'Access,
     Gt'Access,
     Lt'Access
   );


   FIntIntRetInt : array
     (Add .. Sub)
       of IntIntRetInt :=
   (
     Add'Access,
     Sub'Access
   );


   FLineRetString : array
      (Comment_Image .. Non_Comment_Image)
         of LineRetString :=
   (
      Asis.Text.Comment_Image'Access,
      Asis.Text.Debug_Image'Access,
      Asis.Text.Line_Image'Access,
      Asis.Text.Non_Comment_Image'Access
   );


   FRelshipRetCUnitList : array
     (Consistent ..Circular)
       of RelshipRetCUnitList :=
   (
     Consistent'Access,
     Inconsistent'Access,
     Missing'Access,
     Circular'Access
   );


   FRetBool : array
     (Attributes_Are_Supported .. Record_Component_Associations_Normalized)
       of RetBool :=
   (
     Asis.Implementation.Permissions.Attributes_Are_Supported'Access,
     Asis.Implementation.Permissions.Default_In_Mode_Supported'Access,

     Asis.Implementation.Permissions.
        Discriminant_Associations_Normalized'Access,

     Asis.Implementation.Permissions.
        Function_Call_Parameters_Normalized'Access,

     Asis.Implementation.Permissions.Generic_Actual_Part_Normalized'Access,
     Asis.Implementation.Permissions.Generic_Macro_Expansion_Supported'Access,
     Asis.Implementation.Permissions.Implicit_Components_Supported'Access,
     Asis.Implementation.Permissions.Inherited_Declarations_Supported'Access,
     Asis.Implementation.Permissions.Inherited_Subprograms_Supported'Access,
     Asis.Implementation.Permissions.Is_Commentary_Supported'Access,
     Asis.Implementation.Is_Finalized'Access,

     Asis.Implementation.Permissions.
       Is_Formal_Parameter_Named_Notation_Supported'Access,

     Asis.Implementation.Is_Initialized'Access,
     Asis.Implementation.Permissions.Is_Line_Number_Supported'Access,
     Asis.Implementation.Permissions.Is_Prefix_Call_Supported'Access,
     Asis.Implementation.Permissions.Is_Span_Column_Position_Supported'Access,
     Asis.Implementation.Permissions.Object_Declarations_Normalized'Access,
     Asis.Implementation.Permissions.Predefined_Operations_Supported'Access,
     Asis.Implementation.Permissions.
        Record_Component_Associations_Normalized'Access
   );


   FRetCUnit : array
     (FuncEnum.Nil_Compilation_Unit .. FuncEnum.Nil_Compilation_Unit)
       of RetCUnit :=
   (others =>
       ASIStant.Add_Ons.Nil_Compilation_Unit'Access
   );


   FRetCUnitList : array
     (FuncEnum.Nil_Compilation_Unit_List .. FuncEnum.Nil_Compilation_Unit_List)
       of RetCUnitList :=
   (others =>
       ASIStant.Add_Ons.Nil_Compilation_Unit_List'Access
   );


   FRetElem : array
     (FuncEnum.Nil_Element .. FuncEnum.Nil_Element)
       of RetElem :=
   (others =>
       ASIStant.Add_Ons.Nil_Element'Access
   );


   FRetElemList : array
     (FuncEnum.Nil_Element_List .. FuncEnum.Nil_Element_List)
       of RetElemList :=
   (others =>
       ASIStant.Add_Ons.Nil_Element_List'Access
   );


   FRetRelship : array
     (Nil_Relationship .. Nil_Relationship)
       of RetRelship :=
   (others =>
       ASIStant.Add_Ons.Nil_Relationship'Access
   );


   FRetString : array
     (Asis_Implementor .. Status)
       of RetString :=
   (
     Implementation.ASIS_Implementor'Access,
     Implementation.ASIS_Implementor_Information'Access,
     Implementation.ASIS_Implementor_Version'Access,
     Implementation.ASIS_Version'Access,
     Asis.Compilation_Units.Attribute_Value_Delimiter'Access,
     Asis.Ada_Environments.Default_Name'Access,
     Asis.Ada_Environments.Default_Parameters'Access,
     Text.Delimiter_Image'Access,
     Implementation.Diagnosis'Access,
     ASIStant.Enum_Mapping.Status'Access
   );


   FSpanRetBool : array
     (Is_Nil_Sp .. Is_Nil_Sp)
       of SpanRetBool :=
   (others =>
       Text.Is_Nil'Access
   );

   FSpanRetInt : array
     (First_Column .. Last_Line)
       of SpanRetInt :=
   (
     First_Column'Access,
     First_Line'Access,
     Last_Column'Access,
     Last_Line'Access
   );

   FStringCtxRetCUnit : array
     (Compilation_Unit_Body .. Library_Unit_Declaration)
       of StringCtxRetCUnit :=
   (
     Asis.Compilation_Units.Compilation_Unit_Body'Access,
     Asis.Compilation_Units.Library_Unit_Declaration'Access
   );


   FStringRetNull : array
     (Finalize .. Initialize)
       of StringRetNull :=
   (
     Asis.Implementation.Finalize'Access,
     Asis.Implementation.Initialize'Access
   );

   FStringStringRetBool : array
     (Eq_SS .. Lt_SS)
       of StringStringRetBool :=
   (
     Eq'Access,
     Gt'Access,
     Lt'Access
   );

   FStringStringRetString : array
     (Concat .. Concat)
       of StringStringRetString :=
   (others =>
     Concat'Access
   );

end ASIStant.FuncArr;