
#define DCPLX
#include "atlas_misc.h"
#include "atlas_level1.h"
#include "cblas.h"

void cblas_zdotu_sub(const int N, const void *X, const int incX, 
                      const void *Y, const int incY, void * dot)
{
   const double *x = X, *y = Y;
   int incx = incX, incy = incY;

   if (incX < 0)
   {
      if (incY < 0) { incx = -incx; incy = -incY; }
      else x += -incX * ((N-1)<<1);
   }
   else if (incY < 0)
   {
      incy = -incy;
      incx = -incx;
      x += (N-1)*(incX<<1);
   }
   ATL_zdotu_sub(N, x, incx, y, incy, dot);
}
