
#include "compat.h"

/* ident "$Id: sigsend.c,v 2.1 1999/03/16 15:49:18 bkorb Exp $" */


/* Get a declaration for sigsend */
# include <signal.h>
  
# ifndef HAVE_SIGSEND
typedef enum idtype {
    P_PID,      /* process id type */
    P_PPID,     /* parent process id type */
    P_PGID,     /* process group (job control group) id type */
    P_SID,      /* session id type */
    P_CID,      /* scheduling class id type */
    P_UID,      /* user id type */
    P_GID,      /* group id type */
    P_ALL       /* all processes */
} idtype_t;
# endif

    int
sigsend (idtype_t idtype, id_t id, int sig)
{
    switch (idtype) {
    case P_PID:     /* raise SIG for process ID  */
        kill ((pid_t)id, sig);
        break;

    case P_PGID:    /* raise SIG for each process in group ID */
        kill ((pid_t)-id, sig);
        break;

    case P_ALL:     /* set errno, or else signal all processes */
        kill ((pid_t)-1, sig);
        break;

    case P_GID:
    case P_UID:
    case P_SID:
    case P_CID:
        errno = EINVAL;
        return -1;
        /*NOTREACHED*/
    }

    return 0;
}
