#! /usr/bin/perl
# parsetree.c-gen.pl -- generate representation of a parse tree
# Written by Charles Briscoe-Smith; refer to the file LEGAL for details.

while (<>) {
	if ($_ eq "\f\n") { last; }
	next if /^\#/;
	if (/^\|(.*)/) { print "$1\n"; next; }
	if (/^\:(.*)/) {
		$name=$1;
		print "\nstruct $name {\n";
		@sigs=();
		@vars=();
		while(<>) {
			last if /^\.$/;
			if (/^\|(.*)/) { print "$1\n"; next; }
			if (/^(.*)\: *(.*)$/) {
				push @vars, $1;
				push @sigs, $2;
				print "\t$2;\n";
			} else {
				die "bad line `$_'\n";
			}
		}
		$sigs=join ",\n\t", @sigs;
		print "};\n\nextern struct $name *new${name}($sigs);\n";
		push @implementations,
			"\n",
			"struct $name *new${name}(",
			$sigs,
			")\n{\n",
			"\tstruct $name *new=(struct $name *) ",
			"xmalloc(sizeof(struct $name));\n";
		foreach $v (@vars) {
			push @implementations, "\tnew->$v=$v;\n";
		}
		push @implementations, "\treturn new;\n}\n";
	} else {
		die "bad line `$_'\n";
	}
}

print "\n\f\n#ifndef SEEN_parsetree_h\n\n";
print "#include <stdlib.h>\n#include <stdio.h>\n";

while (<>) { print; }

print @implementations;

print "\n#endif /* SEEN_parsetree_h */\n";
