(* camlp4r *)
(***********************************************************************)
(*                                                                     *)
(*                             Camlp4                                  *)
(*                                                                     *)
(*        Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt     *)
(*                                                                     *)
(*  Copyright 1998 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* Id *)

let go = ref (fun () -> ());;
let name = ref "odyl";;

let first_arg_no_load () =
  let rec loop i =
    if i < Array.length Sys.argv then
      match Sys.argv.(i) with
        "-I" -> loop (i + 2)
      | "-nolib" -> loop (i + 1)
      | "-where" -> loop (i + 1)
      | "--" -> i + 1
      | s ->
          if Filename.check_suffix s ".cmo" ||
             Filename.check_suffix s ".cma" then
            loop (i + 1)
          else i
    else i
  in
  loop 1
;;

Arg.current := first_arg_no_load () - 1;;
