package Language::INTERCAL::Backend::Perl;

# Inline compiler backend for CLC-INTERCAL

# This file is part of CLC-INTERCAL.

# Copyright (C) 1999 Claudio Calvelli <lunatic@assurdo.com>, all rights reserved

# WARNING - do not operate heavy machinery while using CLC-INTERCAL

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

use vars qw($VERSION);
$VERSION = '0.05';

use Language::INTERCAL::Backend::PerlText;

sub backend {
    my ($name, $ptree, $filename, $line, @args) = @_;
    @args == 1 or die
	'013 SYNTAX IS "backend PARSE_TREE \'Perl\', <program_name>" '
      . " at $filename line $line\n";
    my $prog_name = shift @args;
    my $c =
	"\*$filename\::$prog_name = sub " .
	Language::INTERCAL::Backend::PerlText::_generate_perl
	    ($ptree, $prog_name);
    $@ = '';
    eval $c;
    die $@ if $@;
}

sub suffix { '' }

1;

__END__

=head1 NAME

Language::INTERCAL::Backend::Perl - Default back end for CLC-INTERCAL

=head1 SYNOPSIS

    use Language::INTERCAL;

    my $program = compile Language::INTERCAL 'program text';

    $program->backend('Perl', 'fun');

    fun();

=head1 DESCRIPTION

I<Language::INTERCAL::Backend::Perl> contains a back end for
I<Language::INTERCAL> which creates a Perl subroutine in the
caller's namespace.

To call this back end, use the method I<backend> of package
I<Language::INTERCAL>, with the string 'Perl' as first argument and the
name of the subroutine to be created as second argument.

To use the resulting subroutine, just call it with up to two parameters,
the standard input (a filehandle or CODE reference) and the standard output
(ditto). If only one parameter is given, STDOUT is assumed for output. If none
is given, STDIN is assumed for input. See the discussion towards the beginning
of L<Language::INTERCAL>.

=head1 COPYRIGHT

This module is part of CLC-INTERCAL.

Copyright (c) 1999 by Claudio Calvelli E<lt>C<lunatic@assurdo.com>E<gt>,
all (f)rights reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

=head1 SEE ALSO

A qualified psychiatrist.

