#!/bin/csh -fe

#set echo

if ( ! $?CTMPLDIR ) then
  echo "Do not run $0 by hand. Run 'make install' instead."
  exit 1
endif

##### try to guess, where the tclsh executable is located
unset tclsh
foreach x ($path)
  if ( -x $x/tclsh ) then
    set tclsh = $x/tclsh
    break
  endif
end
#echo ${0}: using '`'$tclsh\'

if ( ! $?tclsh ) then
  echo "${0}: cannot locate tclsh-executable. Please make sure it can"
  echo "    be found via the PATH environment variable and try again."
  exit 1
endif
  

## make all the directories we need
foreach x ($BINDIR $TCLSRCDIR $CTMPLDIR $MAN1DIR $DOCDIR)
  set y = ""
  while ( ! -d $x ) 
    set y = $y/$x:t
    set x = $x:h
  end
  while ( $y != "" )
    set x = $x/$y:t
    set y = $y:h
    mkdir $x
  end
end


## first the easy copying stuff
echo "copying scripts, template files, release notes and an example"
cp tcl/*.tcl            $TCLSRCDIR
cp c/*.c c/template.man $CTMPLDIR
cp example/{main.c,cmdline.cli,makefile} $DOCDIR
if (-e .Versions) cp .Versions $DOCDIR
if (-e CHANGES) cp CHANGES $DOCDIR

## the manual pages get their version inserted, as well as a pointer
## to an example file. 
echo "sedding manual pages"
set docdir = `echo $DOCDIR`
foreach x (*.man)
  sed -e "1,30s/|Version|/$VERSION/" \
      -e "s,|Example|,$docdir," \
  $x > $MAN1DIR/$x:r.1
end

##
## special handling of the main file
##
set TCLSRCDIR = $TCLSRCDIR
set CTMPLDIR = $CTMPLDIR
echo "sedding main file"
sed -e '1s%^.*$%#\!'$tclsh'%' \
    -e "1,30s%set *tclbase *|tclbase|%set tclbase $TCLSRCDIR%" \
    -e "1,30s%set *cbase *|cbase|%set cbase $CTMPLDIR%" \
    -e "1,30s%|Version|%$VERSION%" \
        tcl/clig >$BINDIR/clig
chmod +x $BINDIR/clig


##
## try to install convenience links, if LROOT is usable
##
./clink.sh $LROOT/bin $BINDIR/clig
./clink.sh $LROOT/man/man1 $MAN1DIR/clig.1



##### end #####
