;;; The following illustrates a compile problem with inlining a
;;; structure slot setter function.

(declaim (optimize (safety 0) (speed 3)))

(defstruct (abc)
  (x 0d0 :type double-float)
  (y 0d0 :type double-float))

(declaim (start-block tst1 tst2))  ; Depends on block compile.

(defun tst1 (state)
  (setf (abc-x state) 1d0))  ; Breaks
;  (setf (abc-y state) 1d0))  ; Works

(defun tst2 (state)
  (declare (type abc state))
  (let ((w (abc-x state)))
    (setf (abc-x state) w) ; << This call is not inlined.
    1d0))
