(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  dyn.ml                                  *)
(****************************************************************************)

open Std;;

(* Dynamics, programmed with DANGER !!! *)

type t = string * Obj.t;;

let dyntab = ref ([] : string list);;

let create s =
  if List.mem s !dyntab then anomaly "dyn: already declared this dynamic";
  dyntab := add_set s !dyntab;
  ((fun v -> (s,Obj.repr v)),
   (fun (s',rv) ->
      if s = s' then Obj.magic rv
      else failwith "dyn__out"))
;;
let tag (s,_) = s;;

(* $Id: dyn.ml,v 1.8 1999/06/29 07:47:15 loiseleu Exp $ *)
