(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                Program.v                                 *)
(****************************************************************************)

Declare ML Module "Progmach" "Program".

Grammar command command0 :=
  lam_comment [ "[{" ident($id1) ":" command($c)"}"  "]" command($c2) ]
    -> [(LAMBDA (XTRA "COMMENT" $c) [$id1]$c2)]
| lams_commanet [ "[{" ident($id1) "," ne_ident_comma_list($idl)
                   ":" command($c)"}" "]" command($c2) ]
    -> [(LAMBDALIST (XTRA "COMMENT" $c) [$id1][$idl]$c2)].

Grammar command make_binder :=
  bind_cons [ ";" ne_ident_comma_list($idl) ":" command($t) make_binder($l) ] 
     -> case [$l] of
          (BINDER $c $l1) -> [(BINDER $c (LAMBDALIST $t [$idl]$l1))]
	esac
| bind_one [ ";" ne_ident_comma_list($idl) ":" command($t) ")" "=" command($c)
             "in" command($c1) ] 
     -> [(BINDER $c (LAMBDALIST $t [$idl]$c1))].

Grammar command command1 :=
(* Dsormais dans g_command.ml4 ...
  let_impl [ "<" lcommand($l1) ">" "let" "(" ne_ident_comma_list($idl) ")"
             "=" command($c) "in" command($c1) ]
    -> [(MUTCASE $l1 $c (LAMBDALIST (XTRA "ISEVAR") [$idl]$c1))] |
*)
  let_expl [ "<" lcommand($l1) ">" "let" "(" ne_ident_comma_list($idl)
             ":" command($t) make_binder($l) ]
    -> case [$l] of  
      	  (BINDER $c $l2) -> [(MUTCASE $l1 $c (LAMBDALIST $t [$idl]$l2))]
       esac
| letlist [ "<" lcommand($l1) ">" "let" "(" ne_ident_comma_list($idl)
            ":" command($t) ")" "=" command($c) "in" command($c1) ]
  -> [(MUTCASE $l1 $c (LAMBDALIST $t [$idl]$c1))]

(* Dsormais dans g_command.ml4 ...
| if_then_else [ "<" lcommand($l1) ">" "if" command($c1) "then" command($c2)
                 "else" command($c3) ]
  -> [(MUTCASE $l1 $c1 $c2 $c3)]
*)
.

Grammar command command1 :=
  rec [ "<" lcommand($l1) ">" "rec" ident($id1) "::" "::" "{" command($c1) "}"
        "[" ident($id2) ":" command($c2) "]" command($c3) ]
  -> let $wf = [(CONST #Wf#well_founded_induction.fw)] in
     let $L = [(XTRA "COMMENT" $c1)] in
     let $B = [(LAMBDA $c2 [$id2](LAMBDA (PROD $c2 [<>]$l1) [$id1]$c3))] in
       [(APPLIST $wf $c2 $L $l1 $B)].

Grammar command command5 :=
  annot [ lassoc_command4($c1) "::" "::" "{" command5($c2) "}" ]
          -> [(XTRA "ANNOT" $c1 $c2)].

Grammar tactic simple_tactic :=
   realizer [ "Realizer" comarg($c) ] -> [(Realizer $c)]

|  program [ "Program" ] -> [(Program)]

|  program_exp [ "Program_Expand" ] -> [(Program_Expand)]

|  program_all [ "Program_all" ] -> [(Program_all)].

Grammar vernac vernac :=
  show_prog_n [ "Show" "Program" numarg($n) "." ] -> [(ShowProgram $n)]

| show_prog [ "Show" "Program" "." ] -> [(ShowProgram)].

Syntax constr
  level 0:
    ne_binder_semi_list_cons [(NEBINDERSEMILIST $bind ($LIST $lb))]
      -> [ $bind ";" (NEBINDERSEMILIST ($LIST $lb)) ]
  | ne_binder_semi_list_one [(NEBINDERSEMILIST $bind)] -> [ $bind ]

  | binder [(BINDER $c ($LIST $idl))] ->
       [ (NEIDENTARGCOMMALIST ($LIST $idl)) ":" $c ]

  | ne_identarg_comma_listcons [(NEIDENTARGCOMMALIST $id ($LIST $idl))]
      -> [ $id "," (NEIDENTARGCOMMALIST ($LIST $idl))]
  | ne_identarg_comma_listone [(NEIDENTARGCOMMALIST $id)] -> [ $id ]
  ;

  level 1:
    command_comment [(XTRA "COMMENT" $c)] -> [ $c:L ]
  | comment [(LAMBDA (XTRA "COMMENT" $c) [$id1]$c2)]
      -> [ [<hov 0> "[{" $id1 ":" $c:E "}]" [0 1] $c2:E ] ]
  | prog_rec
      [(APPLIST (CONST #Wf#well_founded_induction.fw) $c2 (XTRA "COMMENT"
         $c1) $l1 (LAMBDA $c2 [$id2](LAMBDA (PROD $c2 [<>]$l1) [$id1]$c3)))]
       -> [ [<hov 0> "<" $l1:E ">rec " $id1 [1 1]":: :: {" $c1 "}" [0 1] 
              "[" $id2 ":" $c2:E "]" [0 1] $c3:E ] ]
  ;

  level 5:
    annot [(XTRA "ANNOT" $c1 $c2)]
      -> [ [<hov 0> $c1:L [1 1]":: :: {" (PPUNI$COMMAND $c2):E "}"] ].


Syntax tactic level 0:
  realizer [(Realizer $c)] -> ["Realizer" [1 2] $c ]
| program [(Program)] -> ["Program"]
| program_expand [(Program_Expand)] -> ["Program_Expand"]
| program_all [(Program_all)] -> ["Program_all"].



(* $Id: Program.v,v 1.14 1999/06/29 07:47:57 loiseleu Exp $ *)
