(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                genpp.mli                                 *)
(****************************************************************************)

open Pp
open Names
open Mlterm
open Vernacinterp

val open_par : bool -> std_ppcmds
val close_par : bool -> std_ppcmds

val uncurry_list : ('a -> std_ppcmds) -> 'a list -> std_ppcmds
val uncurry_list2 : ('a -> std_ppcmds) -> 'a list -> std_ppcmds

type extraction_params = {
  needed : identifier list;		(* constants to keep *)
  expand : identifier list;		(* constants to expand *)
  expansion : bool;			(* do we expand *)
  exact : bool				(* without recursivity *)
  }

val parse_param : vernac_arg list -> extraction_params

module type MLPP = 
  sig
    (* fonction d'optimisation *)
    val opt : extraction_params -> mLdecl list -> mLdecl list
    (* suffixe du fichier *)
    val suffixe : string
    (* types co-inductifs admis/non admis *)
    val cofix : bool
    (* pretty-print de l'environnement *)
    val pp_of_env : mLdecl list -> std_ppcmds
    (* the renaming functions *)
    module Renaming : Fwtoml.RENAMING
  end

module Pp_to_file : functor (M:MLPP) ->
  sig
    module Translation : Fwtoml.TRANSLATION
    val pp_recursive : extraction_params -> std_ppcmds
    val write_extraction_file : string -> extraction_params -> unit
    val write_extraction_module : identifier -> unit
  end
