open Pp;;

type elem = 
  | Sep of int * int
  | String of string
  | Std_ppcmds of std_ppcmds
  | Open of string
  | Close;;

let open_box = function
  | "h" -> hB 0
  | "v" -> vB 0
  | "hov" -> hVB 0
  | "hv" -> hOVB 0
  | _ -> hB 0
;;

(*generating stream *)
let rec expand_box_body nbr sep0 sep1 is_first strm =
 match strm with parser
 [< 'elem >] ->
 if nbr <= 0 then begin
   match elem with
    | String str -> [< if is_first then [< >]
                      else [< 'bRK sep1 >]; 'sTR str;
                   expand_box_body 0 sep0 sep0 false strm >]
    | Std_ppcmds s -> [< if is_first then [< >]
                      else [< 'bRK sep1 >]; s;
                   expand_box_body 0 sep0 sep0 false strm >]
    | Sep (x0,x1) -> expand_box_body 0 sep0 (x0,x1) is_first strm
    | Open str -> [< if is_first then [< >]
                    else [< 'bRK sep1 >]; 'open_box str;
                 expand_box_body 1 sep0 sep0 false strm >]
    | Close -> raise (Stream.Error "")
 end
  else (match elem with
  | String str -> [< 'sTR str; expand_box_body nbr sep0 sep1 is_first strm >]
  | Std_ppcmds s -> [< s; expand_box_body nbr sep0 sep1 is_first strm >]
  | Sep (x0,x1) -> [< 'bRK (x0,x1); expand_box_body nbr sep0 sep1 is_first strm >]
  | Open str -> [< 'open_box str; expand_box_body (nbr + 1) sep0 sep1 is_first strm >]
  | Close -> [< 'cLOSE; expand_box_body (nbr - 1) sep0 sep1 is_first strm >])
 | [< >] -> [< >]
;;


let box str sep strm =
 [< 'open_box str; expand_box_body 0 sep sep true strm;
 'cLOSE >];;

let integerpp i = String (string_of_int i);;
