(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  Min.v                                   *)
(****************************************************************************)
Require Arith.

(**************************************************************************)
(*                    minimum of two natural numbers                      *)
(**************************************************************************)

Fixpoint min [n:nat] : nat -> nat :=  
[m:nat]Cases n m of
          O      _     => O
       | (S n')  O     => O
       | (S n') (S m') => (S (min n' m'))
       end.

Lemma min_SS : (n,m:nat)((S (min n m))=(min (S n) (S m))).
Proof.
Auto with arith.
Qed.

Lemma le_min_l : (n,m:nat)(le (min n m) n).
Proof.
Induction n; Intros; Simpl; Auto with arith.
Elim m; Intros; Simpl; Auto with arith.
Qed.
Hints Resolve le_min_l : arith v62.

Lemma le_min_r : (n,m:nat)(le (min n m) m).
Proof.
Induction n; Simpl; Auto with arith.
Induction m; Simpl; Auto with arith.
Qed.
Hints Resolve le_min_r : arith v62.

(* min n m is equal to n or m *)

Lemma min_case : (n,m:nat)(P:nat->Set)(P n)->(P m)->(P (min n m)).
Proof.
Induction n; Simpl; Auto with arith.
Induction m; Intros; Simpl; Auto with arith.
Pattern (min n0 n1); Apply H ; Auto with arith.
Qed.


(* $Id: Min.v,v 1.8 1999/06/29 07:48:33 loiseleu Exp $ *)
