(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  Mult.v                                  *)
(****************************************************************************)

(* Omega solve only linear goals. It fails on goals with "mult" *)
(* except if one of the multiplicands is a constant             *)
(* as in mult_n_1 and mult_1_n                                  *)

Require Omega.
Require Le_omega.
Require Lt_omega.
Require Plus_omega.
Require Minus_omega.

(**********************************************************)
(* Multiplication                                         *)
(**********************************************************)

Lemma mult_plus_distr : 
      (n,m,p:nat)((mult (plus n m) p)=(plus (mult n p) (mult m p))).
Proof.
Intros; Elim n; Simpl; Intros; Trivial with arith v62.
Elim plus_assoc_l; Elim H; Auto with arith v62.
Qed.
Hints Resolve mult_plus_distr : arith.

Lemma mult_minus_distr : (n,m,p:nat)((mult (minus n m) p)=(minus (mult n p) (mult m p))).
Proof.
Intros; Pattern n m; Apply nat_double_ind; Simpl; Intros; Trivial with arith v62.
Elim minus_plus_simpl; Auto with arith v62.
Qed.
Hints Resolve mult_minus_distr : arith.

Lemma mult_O_le : (n,m:nat)(m=O)\/(le n (mult m n)).
Proof.
Induction m; Simpl; Auto with arith v62.
Qed.
Hints Resolve mult_O_le : arith.

Lemma mult_assoc_r : (n,m,p:nat)((mult (mult n m) p) = (mult n (mult m p))).
Proof.
Intros; Elim n; Intros; Simpl; Auto with arith v62.
Rewrite mult_plus_distr.
Elim H; Auto with arith v62.
Qed.
Hints Resolve mult_assoc_r : arith.

Lemma mult_assoc_l : (n,m,p:nat)(mult n (mult m p)) = (mult (mult n m) p).
Proof.
Auto with arith v62.
Qed.
Hints Resolve mult_assoc_l : arith.

Lemma mult_1_n : (n:nat)(mult (S O) n)=n.
Proof.
Intros; Omega.
Qed.
Hints Resolve mult_1_n : arith.

Lemma mult_sym : (n,m:nat)(mult n m)=(mult m n).
Proof.
Intros; Elim n; Intros; Simpl; Auto with arith v62.
Elim mult_n_Sm.
Elim H; Apply plus_sym.
Qed.
Hints Resolve mult_sym : arith.

Lemma mult_n_1 : (n:nat)(mult n (S O))=n.
Proof.
Intros; Omega.
Qed.
Hints Resolve mult_n_1 : arith.


(* $Id: Mult_omega.v,v 1.3 1999/06/29 13:09:06 loiseleu Exp $ *)
