(* $Id: get_comm.ml,v 1.2 1997/11/19 13:58:01 ddr Exp $ *)

value buff = ref (String.create 80);
value store len x =
  do if len >= String.length buff.val then
       buff.val := buff.val ^ String.create (String.length buff.val)
     else ();
     buff.val.[len] := x;
  return succ len
;
value get_buff len = String.sub buff.val 0 len;

value rec skip_spaces =
  parser
  [ [: `' ' | '\n' | '\b'; s :] -> skip_spaces s
  | [: :] -> () ]
;

value rec ident len =
  parser
  [ [: `('a'..'z' | 'A'..'Z' | '0'..'9' as c); s :] -> ident (store len c) s
  | [: :] -> get_buff len ]
;

value rec args al len =
  parser
  [ [: `'*'; s :] -> args1 al len s
  | [: `' '; s :] -> do skip_spaces s; return args [get_buff len :: al] 0 s
  | [: `c; s :] -> args al (store len c) s
  | [: :] -> raise Not_found ]
and args1 al len =
  parser
  [ [: `')' :] -> al
  | [: s :] -> args al (store len '*') s ]
;

value rec find_comm =
  parser
  [ [: `'('; s :] -> find_comm1 s
  | [: `_; s :] -> find_comm s
  | [: :] -> raise Not_found ]
and find_comm1 =
  parser
  [ [: `'*'; _ = skip_spaces; t = ident 0; _ = skip_spaces; s :] ->
      if t = "camlp4" || t = "camlp4r" || t = "camlp4o" then (t, args [] 0 s)
      else end_of_comm_resume s
  | [: s :] -> find_comm s ]
and end_of_comm_resume =
  parser
  [ [: `'*'; s :] -> end_of_comm_resume1 s
  | [: `_; s :] -> end_of_comm_resume s
  | [: :] -> raise Not_found ]
and end_of_comm_resume1 =
  parser
  [ [: `')'; s :] -> find_comm s
  | [: s :] -> end_of_comm_resume s ]
;

value f fname =
  let ic = open_in fname in
  let r =
    try
      let (comm, args) =
        try find_comm (Stream.of_channel ic) with
        [ Not_found -> ("camlp4r", []) ]
      in
      (comm, List.rev args)
    with
    [ e -> do close_in ic; return raise e ]
  in
  do close_in ic; return r
;
