(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                gallina.ml                                *)
(****************************************************************************)

open Init;;

let vfiles = ref ([] : string list)
;;

let option_moins = ref false
;;

let option_stdout = ref false
;;

let traite_fichier f = 
  try 
    let chan_in = open_in (f^".v") in 
    let buf = Lexing.from_channel chan_in in
    if not !option_stdout then 
      chan_out := open_out (f ^ ".g");
    try while true do
         Lex_coq.action buf
        done
    with Lex_coq.Fin_fichier -> begin flush !chan_out;
      	       	       	       	      close_in chan_in;
				      if not !option_stdout then
      	       	       	       	          close_out !chan_out
                                end
  with Sys_error _ -> () 
;;

let traite_stdin () =
  try
    let buf = Lexing.from_channel stdin in
    try while true do
      	  Lex_coq.action buf
	done
    with Lex_coq.Fin_fichier -> flush !chan_out
  with Sys_error _ -> ()
;;

let gallina () =
  let lg_command = Array.length Sys.argv in
  if lg_command < 2 then begin
    output_string stderr "Usage: gallina [-] [-stdout] file1 file2 ...\n";
    flush stderr
  end else 
    let treat = function
       "-"       -> option_moins := true
     | "-stdout" -> option_stdout := true
     | "-nocomments" -> Lex_coq.comments := false
     | f         -> if Filename.check_suffix f ".v" then
       	       	      vfiles := (Filename.chop_suffix f ".v") :: !vfiles
    in
    Array.iter treat Sys.argv;
    if !option_moins then
      traite_stdin ()
    else
      List.iter traite_fichier !vfiles
;;

Printexc.catch gallina ();;

