/*
  comment.ll

  Copyright (c) 1996 Roland Wunderling, Malte Zoeckler
  Copyright (c) 1998 Michael Meeks
  Copyright (c) 1999 Dragos Acostachioaie

  This file is part of DOC++.

  DOC++ is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License as published by the Free Software Foundation; either
  version 2 of the license, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

%{

#include <assert.h>
#include <ctype.h>
#include <iostream.h>
#include <stdarg.h>
#include <stdio.h>

#include "doc.h"

static const char*	inputString ;
static int		inputPosition ;

static Entry*		current      = 0 ;

static int		yyLineNr = 0 ;

static void	lineCount()
{
  for( const char* c = yytext ; *c ; ++c )
    yyLineNr += (*c == '\n') ;
}

#undef	YY_INPUT
#define	YY_INPUT(buf,result,max_size) result=yyread(buf,max_size);

static int yyread(char *buf,int max_size)
{
    int c=0;
    while( c < max_size && inputString[inputPosition] )
    {
	*buf = inputString[inputPosition++] ;
	c++; buf++;
    }
    return c;
}

static char nonewline(char c)
{
  return (c == '\n') ? ' ' : c;
}

%}

%x	CppDoc
%x	CppMemo
%x	See
%x	Args
%x	Type
%x	Author
%x	Name
%x	Version
%x	Param
%x	Memo
%x	Return
%x	Exception

%%

<CppMemo>[^.]				{ current->memo += nonewline(*yytext);
					  current->doc  += yytext ; }
<CppMemo>"."|"?"|"!"[ \t\n]*		{ BEGIN(CppDoc);
					  lineCount();
					  current->doc  += yytext ; }
<CppDoc>(\n|.)				{ current->doc += *yytext;
					  lineCount();
					}
<CppMemo>"/"("*"|"/")			{ current->memo += yytext ; }
<CppDoc>"/"("*"|"/")			{ current->doc  += yytext ; }

<*>^"@see"[ \t\n]*			{ lineCount() ;
					  current->see.append(
					      new McString
					  ) ;
					  BEGIN( See ) ;
					}
<*>^"@author"[ \t\n]*			{ lineCount() ;
					  BEGIN( Author ) ; }
<*>^"@version"[ \t\n]*			{ lineCount() ;
					  BEGIN( Version ) ; }
<*>^"@param"[ \t\n]*			{ lineCount() ;
					  current->param.append(
					      new McString
					  ) ;
					  BEGIN( Param ) ;
					}
<*>^"@exception"[ \t\n]*		{ lineCount() ;
					  current->exception.append(
						new McString
					  ) ;
					  BEGIN( Exception ) ;
					}
<*>^"@return"[ \t\n]*			{ lineCount() ;
					  BEGIN( Return ) ; }
<*>^"@name"[ \t]*			{ lineCount() ;
					  current->name.clear() ;
					  current->section = MANUAL_SEC ;
					  BEGIN( Name ) ;
					}
<*>^"@memo"[ \t\n]*			{ lineCount() ;
					  current->memo.clear() ;
					  BEGIN( Memo ) ;
					}

<*>^"@type"[ \t\n]*			{ lineCount() ;
					  current->type.clear() ;
					  BEGIN( Type ) ;
					}
<*>^"@args"[ \t\n]*			{ lineCount() ;
					  current->args.clear() ;
					  BEGIN( Args ) ;
					}

<Name>.*				{ current->name = yytext ; }
<Name>\n				{ BEGIN( CppDoc ) ; yyLineNr++ ; }

<Type>.*				{ current->type = yytext ; }
<Type>\n				{ BEGIN( CppDoc ) ; yyLineNr++ ; }

<Args>.*				{ current->args = yytext ; }
<Args>\n				{ BEGIN( CppDoc ) ; yyLineNr++ ; }

<Author>.				{ current->author  += *yytext ; }
<Version>.				{ current->version += *yytext ; }
<See>.					{ *(current->see.last())       += *yytext ; }
<Param>.				{ *(current->param.last())     += *yytext ; }
<Exception>.				{ *(current->exception.last()) += *yytext ; }
<Memo>.					{ current->memo += nonewline(*yytext); }
<Return>.				{ current->retrn   += *yytext ; }

<Author>\n[ \t\n]*			{
					current->author += '\n';
					}
<Version>\n[ \t\n]*			{
					current->version += '\n';
					}
<See>\n[ \t\n]*				{ *(current->see.last())       += '\n' ; }
<Param>\n[ \t\n]*			{ *(current->param.last())     += '\n' ; }
<Exception>\n[ \t\n]*			{ *(current->exception.last()) += '\n' ; }
<Memo>\n[ \t\n]*			{ current->memo += nonewline(*yytext); }
<Return>\n[ \t\n]*			{ current->retrn   += *yytext ; }

<*>.
<*>\n					{ yyLineNr++ ; }

%%

void	parseDoc(Entry* rt)
{
    if( rt->doc.length() )
    {
	Entry* _current = current ;
	rt->program = rt->doc ;
	rt->doc.clear() ;
	inputString   = rt->program ;
	inputPosition = 0 ;
	current = rt ;
	commentYYrestart( commentYYin ) ;
	if( rt->memo.length() )
	    BEGIN( CppDoc ) ;
	else
	    BEGIN( CppMemo ) ;
	commentYYlex() ;
	rt->program.clear() ;
	current = _current ;
    }
}

extern "C" {
  int commentYYwrap()
    {
    return 1;
    }
};
