indexing

	description: "This is used by INHERIT_LIST to contain a class"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class KLASS

inherit

	ANY
		redefine
			is_equal
		end

creation

	make_with_name

feature

	is_equal(other: like Current): BOOLEAN is
		do
			Result := name.is_equal(other.name) 
		end
			
	make_with_name(klass_name: STRING) is
		do
			name := klass_name
			!!renam.make(0,-1)
			!!undef.make(0,-1)
		end

	add_rename_clause(feat, to: STRING) is
		do
			renam.add_last(feat + " as " + to)
		end

	add_undefine_clause(feat: STRING) is
		do
			undef.add_last(feat)
		end

feature {KLASS}

	renam: ARRAY[STRING]
	undef: ARRAY[STRING]

	name: STRING

feature {INHERIT_LIST}

	get_inherit_details: ARRAY[STRING] is
		local
			upper, i, offset: INTEGER
		do
			if renam.empty then
				upper := 0
			else
				upper := 1 + renam.count
			end
			if not undef.empty then
				upper := upper + 1 + undef.count
			end
			if upper > 0 then
				upper := upper + 1
			end
			
			!!Result.make(0, upper)
			Result.put(name, 0)
			if upper > 0 then
				if not renam.empty then
					Result.put("%Trename", 1)
					from
						i := 0
					until
						i >= renam.count
					loop
						Result.put("%T%T" + renam @ i, 2 + i)
						i := i + 1
					end
					offset := i + 2
				else
					offset := 1
				end
				if not undef.empty then
					Result.put("%Tundefine", offset)
					from
						i := 0
					until
						i >= undef.count
					loop
						Result.put("%T%T" + undef @ i, offset + i + 1)
						i := i + 1
					end
				end
				Result.put("%Tend", Result.upper)
			end
		end

end	
