%{
indexing
	description: "Scan C header file for function prototypes"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:44 $"
	revision: "$Revision: 1.1.1.1 $"

class C_PROTOTYPE_SCANNER

inherit

	YY_COMPRESSED_SCANNER_SKELETON

	C_PROTOTYPE_TOKENS

creation

	make_with_file

%}

ANY   .|\n
WS    [ \r\f\v\t\n]
INDIR \*+
ARRAY \[\]
ID    [_a-zA-Z][_a-zA-Z0-9]*
ARGS  "("{WS}*[^*.][^).]*")"
PROTO ({ID}{WS}+)*({ID}{WS}*{INDIR}{WS}*)?{ID}{WS}*{ARGS}{WS}*";"
TYPE  {WS}*({ID}|(({ID}{WS}*)+{INDIR})){WS}*

%x SC_PROTO
%x SC_FILE

%%

^#.*                   { set_start_condition (SC_FILE)
                         less (0)                                    }
<SC_FILE>#{WS}+[0-9]+{WS}+\" -- chew leading junk
<SC_FILE>\"{WS}.*\n    { set_start_condition (INITIAL)               }
<SC_FILE>[^"\n]+       { !!file_name.make (0)
                         file_name.copy (text)
                         -- This looks dumb, but as far as I can tell
                         -- STRING.last_index_of is broken :(
                         file_name.mirror
                         file_name := file_name.substring (1, (file_name.index_of('/',1)-1))
                         file_name.mirror                            }

{PROTO}                { set_start_condition (SC_PROTO)
                         !!full_text.make (0)
                         full_text.copy (text)
                         less (0)                                    }
<SC_PROTO>"("{TYPE}")" { last_token := TOK_NOARGS                    }
<SC_PROTO>"("{TYPE}"," { unread_character ('(')                      }
<SC_PROTO>","{TYPE}"," { unread_character (',')                      }
<SC_PROTO>","{TYPE}")" { unread_character (')')                      }
<SC_PROTO>{ID}         { last_token := TOK_ID;    last_value := text }
<SC_PROTO>{INDIR}      { last_token := TOK_INDIR; last_value := text }
<SC_PROTO>{ARRAY}      { last_token := TOK_ARRAY; last_value := text }
<SC_PROTO>"("          { last_token := TOK_LPAREN;                   }
<SC_PROTO>","          { last_token := TOK_COMMA;                    }
<SC_PROTO>")"          { last_token := TOK_RPAREN;                   }
<SC_PROTO>";"          { set_start_condition (INITIAL)               }
<SC_PROTO>{ANY}        -- chew leftovers

[^#_a-zA-Z]*           -- chew leftovers
.#                     -- chew # not at start of line
{ANY}                  -- chew leftovers

%%

feature -- Access

	last_value: STRING

	full_text: STRING

	file_name: STRING

end


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
