indexing
	description: "External C calls to the GTK library."
	gtk_klass: "GtkWidget"
	gtk_file: "gtkwidget.h"
	status: "See notice at end of class"
	signals: "show hide map unmap realize unrealize draw draw_focus draw_default size_request size_allocate state_changed parent_set style_set add_accelerator remove_accelerator grab_focus selection_received selection_get drag_leave drag_begin drag_end drag_data_delete drag_motion drag_drop drag_data_get drag_data_received debug_msg "
	events: "event button_press_event button_release_event motion_notify_event delete_event destroy_event expose_event key_press_event key_release_event enter_notify_event leave_notify_event configure_event focus_in_event focus_out_event map_event unmap_event property_notify_event selection_clear_event selection_request_event selection_notify_event proximity_in_event proximity_out_event visibility_notify_event client_event no_expose_event "

class
	C_GTK_WIDGET

feature -- External C functions

	gtk_widget_get_type: INTEGER is 
			-- Parsed as:
			-- GtkType gtk_widget_get_type (
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GtkType	   gtk_widget_get_type		  (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_newv (a_type: INTEGER; a_nargs: INTEGER; a_args: POINTER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_widget_newv (
			--     GtkType a_type,
			--     guint a_nargs,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GtkWidget* gtk_widget_newv		  (GtkType		type,
			-- 					   guint		nargs,
			-- 					   GtkArg	       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_ref (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_ref (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_ref		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_unref (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_unref (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_unref		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_destroy (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_destroy (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_destroy		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_destroyed (a_widget: POINTER; a_widget_pointer: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_destroyed (
			--     GtkWidget *a_widget,
			--     GtkWidget **a_widget_pointer
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_destroyed		  (GtkWidget	       *widget,
			-- 					   GtkWidget	      **widget_pointer);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get (a_widget: POINTER; a_arg: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_get (
			--     GtkWidget *a_widget,
			--     GtkArg *a_arg
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_get		  (GtkWidget	       *widget,
			-- 					   GtkArg	       *arg);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_getv (a_widget: POINTER; a_nargs: INTEGER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_getv (
			--     GtkWidget *a_widget,
			--     guint a_nargs,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_getv		  (GtkWidget	       *widget,
			-- 					   guint		nargs,
			-- 					   GtkArg	       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_setv (a_widget: POINTER; a_nargs: INTEGER; a_args: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_setv (
			--     GtkWidget *a_widget,
			--     guint a_nargs,
			--     GtkArg *a_args
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_setv		  (GtkWidget	       *widget,
			-- 					   guint		nargs,
			-- 					   GtkArg	       *args);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_unparent (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_unparent (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_unparent		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_show (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_show (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_show		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_show_now (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_show_now (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void       gtk_widget_show_now            (GtkWidget           *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_hide (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_hide (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_hide		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_show_all (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_show_all (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_show_all		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_hide_all (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_hide_all (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_hide_all		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_map (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_map (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_map		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_unmap (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_unmap (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_unmap		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_realize (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_realize (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_realize		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_unrealize (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_unrealize (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_unrealize		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_queue_draw (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_queue_draw (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_queue_draw	  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_queue_draw_area (a_widget: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_queue_draw_area (
			--     GtkWidget *a_widget,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_queue_draw_area	  (GtkWidget	       *widget,
			-- 					   gint                 x,
			-- 					   gint                 y,
			-- 					   gint                 width,
			-- 					   gint                 height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_queue_clear (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_queue_clear (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_queue_clear	  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_queue_clear_area (a_widget: POINTER; a_x: INTEGER; a_y: INTEGER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_queue_clear_area (
			--     GtkWidget *a_widget,
			--     gint a_x,
			--     gint a_y,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_queue_clear_area	  (GtkWidget	       *widget,
			-- 					   gint                 x,
			-- 					   gint                 y,
			-- 					   gint                 width,
			-- 					   gint                 height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_queue_resize (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_queue_resize (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_queue_resize	  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_draw (a_widget: POINTER; a_area: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_draw (
			--     GtkWidget *a_widget,
			--     GdkRectangle *a_area
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_draw		  (GtkWidget	       *widget,
			-- 					   GdkRectangle	       *area);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_draw_focus (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_draw_focus (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_draw_focus	  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_draw_default (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_draw_default (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_draw_default	  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_size_request (a_widget: POINTER; a_requisition: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_size_request (
			--     GtkWidget *a_widget,
			--     GtkRequisition *a_requisition
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_size_request	  (GtkWidget	       *widget,
			-- 					   GtkRequisition      *requisition);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_size_allocate (a_widget: POINTER; a_allocation: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_size_allocate (
			--     GtkWidget *a_widget,
			--     GtkAllocation *a_allocation
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_size_allocate	  (GtkWidget	       *widget,
			-- 					   GtkAllocation       *allocation);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_child_requisition (a_widget: POINTER; a_requisition: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_get_child_requisition (
			--     GtkWidget *a_widget,
			--     GtkRequisition *a_requisition
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void       gtk_widget_get_child_requisition (GtkWidget	       *widget,
			-- 					     GtkRequisition    *requisition);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_add_accelerator (a_widget: POINTER; a_accel_signal: POINTER; a_accel_group: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER; a_accel_flags: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_add_accelerator (
			--     GtkWidget *a_widget,
			--     gchar *a_accel_signal,
			--     GtkAccelGroup *a_accel_group,
			--     guint a_accel_key,
			--     guint a_accel_mods,
			--     GtkAccelFlags a_accel_flags
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_add_accelerator	  (GtkWidget           *widget,
			-- 					   const gchar         *accel_signal,
			-- 					   GtkAccelGroup       *accel_group,
			-- 					   guint                accel_key,
			-- 					   guint                accel_mods,
			-- 					   GtkAccelFlags        accel_flags);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_remove_accelerator (a_widget: POINTER; a_accel_group: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_remove_accelerator (
			--     GtkWidget *a_widget,
			--     GtkAccelGroup *a_accel_group,
			--     guint a_accel_key,
			--     guint a_accel_mods
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_remove_accelerator  (GtkWidget           *widget,
			-- 					   GtkAccelGroup       *accel_group,
			-- 					   guint                accel_key,
			-- 					   guint                accel_mods);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_remove_accelerators (a_widget: POINTER; a_accel_signal: POINTER; a_visible_only: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_widget_remove_accelerators (
			--     GtkWidget *a_widget,
			--     gchar *a_accel_signal,
			--     gboolean a_visible_only
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_remove_accelerators (GtkWidget           *widget,
			-- 					   const gchar	       *accel_signal,
			-- 					   gboolean		visible_only);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_accelerator_signal (a_widget: POINTER; a_accel_group: POINTER; a_accel_key: INTEGER; a_accel_mods: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint gtk_widget_accelerator_signal (
			--     GtkWidget *a_widget,
			--     GtkAccelGroup *a_accel_group,
			--     guint a_accel_key,
			--     guint a_accel_mods
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- guint	   gtk_widget_accelerator_signal  (GtkWidget           *widget,
			-- 					   GtkAccelGroup       *accel_group,
			-- 					   guint                accel_key,
			-- 					   guint                accel_mods);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_lock_accelerators (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_lock_accelerators (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_lock_accelerators   (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_unlock_accelerators (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_unlock_accelerators (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_unlock_accelerators (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_accelerators_locked (a_widget: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_widget_accelerators_locked (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- gboolean   gtk_widget_accelerators_locked (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_event (a_widget: POINTER; a_event: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_widget_event (
			--     GtkWidget *a_widget,
			--     GdkEvent *a_event
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- gint	   gtk_widget_event		  (GtkWidget	       *widget,
			-- 					   GdkEvent	       *event);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_activate (a_widget: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_widget_activate (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- gboolean   gtk_widget_activate		     (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_scroll_adjustments (a_widget: POINTER; a_hadjustment: POINTER; a_vadjustment: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean gtk_widget_set_scroll_adjustments (
			--     GtkWidget *a_widget,
			--     GtkAdjustment *a_hadjustment,
			--     GtkAdjustment *a_vadjustment
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- gboolean   gtk_widget_set_scroll_adjustments (GtkWidget        *widget,
			-- 					      GtkAdjustment    *hadjustment,
			-- 					      GtkAdjustment    *vadjustment);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_reparent (a_widget: POINTER; a_new_parent: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_reparent (
			--     GtkWidget *a_widget,
			--     GtkWidget *a_new_parent
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_reparent		  (GtkWidget	       *widget,
			-- 					   GtkWidget	       *new_parent);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_popup (a_widget: POINTER; a_x: INTEGER; a_y: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_popup (
			--     GtkWidget *a_widget,
			--     gint a_x,
			--     gint a_y
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_popup		  (GtkWidget	       *widget,
			-- 					   gint			x,
			-- 					   gint			y);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_intersect (a_widget: POINTER; a_area: POINTER; a_intersection: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_widget_intersect (
			--     GtkWidget *a_widget,
			--     GdkRectangle *a_area,
			--     GdkRectangle *a_intersection
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- gint	   gtk_widget_intersect		  (GtkWidget	       *widget,
			-- 					   GdkRectangle	       *area,
			-- 					   GdkRectangle	       *intersection);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_grab_focus (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_grab_focus (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_grab_focus	  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_grab_default (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_grab_default (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_grab_default	  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_name (a_widget: POINTER; a_name: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_set_name (
			--     GtkWidget *a_widget,
			--     gchar *a_name
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_name		  (GtkWidget	       *widget,
			-- 					   const gchar	       *name);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_name (a_widget: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_widget_get_name (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- gchar*	   gtk_widget_get_name		  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_state (a_widget: POINTER; a_state: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_set_state (
			--     GtkWidget *a_widget,
			--     GtkStateType a_state
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_state		  (GtkWidget	       *widget,
			-- 					   GtkStateType		state);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_sensitive (a_widget: POINTER; a_sensitive: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_widget_set_sensitive (
			--     GtkWidget *a_widget,
			--     gboolean a_sensitive
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_sensitive	  (GtkWidget	       *widget,
			-- 					   gboolean		sensitive);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_app_paintable (a_widget: POINTER; a_app_paintable: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_widget_set_app_paintable (
			--     GtkWidget *a_widget,
			--     gboolean a_app_paintable
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_app_paintable	  (GtkWidget	       *widget,
			-- 					   gboolean		app_paintable);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_parent (a_widget: POINTER; a_parent: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_set_parent (
			--     GtkWidget *a_widget,
			--     GtkWidget *a_parent
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_parent	  (GtkWidget	       *widget,
			-- 					   GtkWidget	       *parent);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_parent_window (a_widget: POINTER; a_parent_window: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_set_parent_window (
			--     GtkWidget *a_widget,
			--     GdkWindow *a_parent_window
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_parent_window	  (GtkWidget	       *widget,
			-- 					   GdkWindow	       *parent_window);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_parent_window (a_widget: POINTER): POINTER is 
			-- Parsed as:
			-- GdkWindow* gtk_widget_get_parent_window (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GdkWindow *gtk_widget_get_parent_window	  (GtkWidget	       *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_uposition (a_widget: POINTER; a_x: INTEGER; a_y: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_set_uposition (
			--     GtkWidget *a_widget,
			--     gint a_x,
			--     gint a_y
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_uposition	  (GtkWidget	       *widget,
			-- 					   gint			x,
			-- 					   gint			y);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_usize (a_widget: POINTER; a_width: INTEGER; a_height: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_set_usize (
			--     GtkWidget *a_widget,
			--     gint a_width,
			--     gint a_height
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_usize		  (GtkWidget	       *widget,
			-- 					   gint			width,
			-- 					   gint			height);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_events (a_widget: POINTER; a_events: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_set_events (
			--     GtkWidget *a_widget,
			--     gint a_events
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_events	  (GtkWidget	       *widget,
			-- 					   gint			events);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_add_events (a_widget: POINTER; a_events: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_add_events (
			--     GtkWidget *a_widget,
			--     gint a_events
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void       gtk_widget_add_events          (GtkWidget           *widget,
			-- 					   gint	                events);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_extension_events (a_widget: POINTER; a_mode: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_set_extension_events (
			--     GtkWidget *a_widget,
			--     GdkExtensionMode a_mode
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_extension_events (GtkWidget		*widget,
			-- 					    GdkExtensionMode	mode);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_extension_events (a_widget: POINTER): INTEGER is 
			-- Parsed as:
			-- GdkExtensionMode gtk_widget_get_extension_events (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GdkExtensionMode gtk_widget_get_extension_events (GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_toplevel (a_widget: POINTER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_widget_get_toplevel (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GtkWidget*   gtk_widget_get_toplevel	(GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_ancestor (a_widget: POINTER; a_widget_type: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_widget_get_ancestor (
			--     GtkWidget *a_widget,
			--     GtkType a_widget_type
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GtkWidget*   gtk_widget_get_ancestor	(GtkWidget	*widget,
			-- 					 GtkType	widget_type);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_colormap (a_widget: POINTER): POINTER is 
			-- Parsed as:
			-- GdkColormap* gtk_widget_get_colormap (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GdkColormap* gtk_widget_get_colormap	(GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_visual (a_widget: POINTER): POINTER is 
			-- Parsed as:
			-- GdkVisual* gtk_widget_get_visual (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GdkVisual*   gtk_widget_get_visual	(GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_colormap (a_widget: POINTER; a_colormap: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_set_colormap (
			--     GtkWidget *a_widget,
			--     GdkColormap *a_colormap
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void         gtk_widget_set_colormap    (GtkWidget      *widget,
			-- 					 GdkColormap    *colormap);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_visual (a_widget: POINTER; a_visual: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_set_visual (
			--     GtkWidget *a_widget,
			--     GdkVisual *a_visual
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void         gtk_widget_set_visual      (GtkWidget      *widget, 
			-- 					 GdkVisual      *visual);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_events (a_widget: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_widget_get_events (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- gint	     gtk_widget_get_events	(GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_pointer (a_widget: POINTER; a_x: POINTER; a_y: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_get_pointer (
			--     GtkWidget *a_widget,
			--     gint *a_x,
			--     gint *a_y
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_get_pointer	(GtkWidget	*widget,
			-- 					 gint		*x,
			-- 					 gint		*y);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_is_ancestor (a_widget: POINTER; a_ancestor: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_widget_is_ancestor (
			--     GtkWidget *a_widget,
			--     GtkWidget *a_ancestor
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- gint	     gtk_widget_is_ancestor	(GtkWidget	*widget,
			-- 					 GtkWidget	*ancestor);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_hide_on_delete (a_widget: POINTER): INTEGER is 
			-- Parsed as:
			-- gint gtk_widget_hide_on_delete (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- gint	   gtk_widget_hide_on_delete	(GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_style (a_widget: POINTER; a_style: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_set_style (
			--     GtkWidget *a_widget,
			--     GtkStyle *a_style
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_style		(GtkWidget	*widget,
			-- 					 GtkStyle	*style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_rc_style (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_set_rc_style (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_set_rc_style	(GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_ensure_style (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_ensure_style (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_ensure_style	(GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_style (a_widget: POINTER): POINTER is 
			-- Parsed as:
			-- GtkStyle* gtk_widget_get_style (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GtkStyle*  gtk_widget_get_style		(GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_restore_default_style (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_restore_default_style (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	   gtk_widget_restore_default_style (GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_modify_style (a_widget: POINTER; a_style: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_modify_style (
			--     GtkWidget *a_widget,
			--     GtkRcStyle *a_style
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void       gtk_widget_modify_style      (GtkWidget      *widget,
			-- 					 GtkRcStyle     *style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_composite_name (a_widget: POINTER; a_name: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_set_composite_name (
			--     GtkWidget *a_widget,
			--     gchar *a_name
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void   gtk_widget_set_composite_name	(GtkWidget	*widget,
			-- 					 gchar     	*name);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_composite_name (a_widget: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_widget_get_composite_name (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- gchar* gtk_widget_get_composite_name	(GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_reset_rc_styles (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_reset_rc_styles (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void       gtk_widget_reset_rc_styles   (GtkWidget      *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_push_style (a_style: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_push_style (
			--     GtkStyle *a_style
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_push_style	     (GtkStyle	 *style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_push_colormap (a_cmap: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_push_colormap (
			--     GdkColormap *a_cmap
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_push_colormap	     (GdkColormap *cmap);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_push_visual (a_visual: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_push_visual (
			--     GdkVisual *a_visual
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_push_visual	     (GdkVisual	 *visual);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_push_composite_child is 
			-- Parsed as:
			-- void gtk_widget_push_composite_child (
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_push_composite_child (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_pop_composite_child is 
			-- Parsed as:
			-- void gtk_widget_pop_composite_child (
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_pop_composite_child  (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_pop_style is 
			-- Parsed as:
			-- void gtk_widget_pop_style (
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_pop_style	     (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_pop_colormap is 
			-- Parsed as:
			-- void gtk_widget_pop_colormap (
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_pop_colormap	     (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_pop_visual is 
			-- Parsed as:
			-- void gtk_widget_pop_visual (
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_pop_visual	     (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_default_style (a_style: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_set_default_style (
			--     GtkStyle *a_style
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_set_default_style    (GtkStyle	  *style);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_default_colormap (a_colormap: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_set_default_colormap (
			--     GdkColormap *a_colormap
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_set_default_colormap (GdkColormap *colormap);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_set_default_visual (a_visual: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_set_default_visual (
			--     GdkVisual *a_visual
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_set_default_visual   (GdkVisual	  *visual);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_default_style: POINTER is 
			-- Parsed as:
			-- GtkStyle* gtk_widget_get_default_style (
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GtkStyle*    gtk_widget_get_default_style    (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_default_colormap: POINTER is 
			-- Parsed as:
			-- GdkColormap* gtk_widget_get_default_colormap (
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GdkColormap* gtk_widget_get_default_colormap (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_get_default_visual: POINTER is 
			-- Parsed as:
			-- GdkVisual* gtk_widget_get_default_visual (
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- GdkVisual*   gtk_widget_get_default_visual   (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_shape_combine_mask (a_widget: POINTER; a_shape_mask: POINTER; a_offset_x: INTEGER; a_offset_y: INTEGER) is 
			-- Parsed as:
			-- void gtk_widget_shape_combine_mask (
			--     GtkWidget *a_widget,
			--     GdkBitmap *a_shape_mask,
			--     gint a_offset_x,
			--     gint a_offset_y
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_shape_combine_mask (GtkWidget *widget,
			-- 					    GdkBitmap *shape_mask,
			-- 					    gint       offset_x,
			-- 					    gint       offset_y);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_reset_shapes (a_widget: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_reset_shapes (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_reset_shapes	   (GtkWidget *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_path (a_widget: POINTER; a_path_length: POINTER; a_path: POINTER; a_path_reversed: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_path (
			--     GtkWidget *a_widget,
			--     guint *a_path_length,
			--     gchar **a_path,
			--     gchar **a_path_reversed
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_path		   (GtkWidget *widget,
			-- 					    guint     *path_length,
			-- 					    gchar    **path,
			-- 					    gchar    **path_reversed);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_widget_class_path (a_widget: POINTER; a_path_length: POINTER; a_path: POINTER; a_path_reversed: POINTER) is 
			-- Parsed as:
			-- void gtk_widget_class_path (
			--     GtkWidget *a_widget,
			--     guint *a_path_length,
			--     gchar **a_path,
			--     gchar **a_path_reversed
			-- );
			--
			-- Original C code from gtkwidget.h:
			-- void	     gtk_widget_class_path	   (GtkWidget *widget,
			-- 					    guint     *path_length,
			-- 					    gchar    **path,
			-- 					    gchar    **path_reversed);
		external
			" C | <gtk/gtk.h>"
		end

end -- class C_GTK_WIDGET

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)