indexing
	description: "Creates GTK_CLASS objects from a preprocessed gtk header file."
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/19 21:21:30 $"
	revision: "$Revision: 1.3 $"

class
	GTK_CLASS_LOADER

creation
	run

feature -- Initialization

	run (file_name: STRING; classes: GTK_CLASSES; t: TICKER) is
		local
			c: GTK_CLASS
			file: PLAIN_TEXT_FILE
			line: STRING
			fnm, cnm, pnm, sig: STRING
			i,j: INTEGER
		do
			from
				create file.make_open_read (file_name);
			until
				file.after
			loop
				file.read_line
				line := file.last_string
				if line.count > 0 then
					j := line.index_of (':', 1)
					fnm := line.substring (1,j-1)
					i := j+1
					j := line.index_of (':', i)
					cnm := line.substring (i,j-1)

					create c.make (cnm)
					c.set_h_file_name (fnm)

					i := j+1
					j := line.index_of (':', i)
					if j-i > 1 then
						pnm := line.substring (i,j-1)
						c.set_parent_name (pnm)
					end
					from
						i := j+1
					until
						i > line.count
					loop
						j := line.index_of (' ', i)
						if j = 0 then
							j := line.count + 1
						end
						sig := line.substring (i, j-1)
						if sig.substring_index("event", 1) /= 0 then
							c.events.extend (line.substring (i, j-1))
						else 
							c.signals.extend (line.substring (i, j-1))
						end
						i := j+1
					end

					if cnm.count > 0 then
						classes.extend (c)
					end
				end
			end
		end

end -- class GTK_CLASS_LOADER


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
