indexing
	description: "Describes the GTK_CLASS universe"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/19 21:21:30 $"
	revision: "$Revision: 1.2 $"

class
	GTK_UNIVERSE

creation
	make

feature -- Initilization 

	make is
		do
			include_directive := "<gtk/gtk.h>"
			c_flags := "`gtk-config --cflags`"
			create typedefs.make
			create enums.make
			create structs.make
			create prototypes.make
			create classes.make (Current)
		end

feature -- Access

	include_directive: STRING
		-- The #include directive used to pull in the gtk headers
		-- by default "<gtk/gtk.h>"

	set_include_directive (id: STRING) is
		do
			include_directive.copy (id)
		end

	c_flags: STRING
		-- The C compiler flags needed to compile with GTK
		-- by default "`gtk-config --cflags`"

	set_c_flags (cf: STRING) is
		do
			c_flags.copy (cf)
		end

	typedefs: C_TYPEDEFS

	enums: C_ENUMS	

	structs: C_STRUCTS

	prototypes: C_PROTOTYPES

	classes: GTK_CLASSES

end -- class GTK_UNIVERSE


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
