indexing
	description: "Root class of the GEL, the GTK Eiffel Librart"
	status: "See notice at end of file"
	author: "Sam O'Connor"
	date: "$Date:"
	revision: "$Revision:"

class
	GTK_ANY

inherit
	ANY

	GTK_ENVIRONMENT

feature -- Initilization

        make_from_c_pointer (a_c_object: POINTER) is
        	require
        		current_not_coupled: (not is_coupled)
        		c_object_not_coupled: objects_by_c_pointer.item (a_c_object) = Void
        	local
        		c: GTK_WIDGET_DESTROYED_COMMAND
		do
			c_object := a_c_object
			create c
			signal_connect ("destroy", c)
			objects_by_c_pointer.extend (Current, c_object)
		ensure
			current_is_coupled: is_coupled
        		current_is_coupled_to_c_object: objects_by_c_pointer.item (a_c_object) = Current
		end

feature -- Access

	signal_connect (a_name: STRING; a_command: GTK_COMMAND) is
			-- FIXME need to set up a callback to clean up
			-- the callback id when the signal is destroyed
		require
			is_coupled: is_coupled
		local
			cbd: GTK_CALLBACK_DATA
		do
			create cbd.make (Current, a_name, a_command, Void)
			cbd.set_callback_handle (c_signal_connect (c_object, e2c (a_name), new_callback_id (cbd)))
		end

feature -- Implementation

	c_object: POINTER

	is_coupled: BOOLEAN is
		do
			Result := c_object /= Default_pointer
		end

	decouple is
		do
			c_object := Default_pointer
		end

	c_gtk_externals: C_GTK_EXTERNALS is
		once
			create Result 
		end

	c_gdk_externals: C_GDK
		once
			create Result 
		end

	c_glib_externals: C_GLIB
		once
			create Result 
		end

end -- class GTK_ANY


--!-----------------------------------------------------------------------------
--! GEL, the GTK Eiffel Library
--! Copyright (C) 1999, Sam O'Connor, Sam@OConnor.net
--!
--! This library is free software; you can redistribute it and/or
--! modify it under the terms of the GNU Library General Public
--! License as published by the Free Software Foundation; either
--! version 2 of the License, or (at your option) any later version.
--!
--! This library is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
--! Library General Public License for more details.
--!
--! You should have received a copy of the GNU Library General Public
--! License along with this library; if not, write to the Free
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!-----------------------------------------------------------------------------
