-- Copyright (C) 1999 Richie Bielak and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "GDK_EVENT_FACTORY - create GDK_EVENT object based %
                 %on call back data"
	author: "Richie Bielak"
	verions: "0.3.1 Gtk+ 1.2.1"
	cvs: "$Id: gdk_event_factory.e,v 1.2 1999/08/07 17:42:38 olly Exp $"

class GDK_EVENT_FACTORY

inherit

	GDK_EXTERNALS

	GDK_CONSTANTS

feature

	make_event (eventp: POINTER): GDK_EVENT is
			-- create an Eiffel object for the event
		require
			eventp_not_void: eventp /= default_pointer
		local
			event_type: INTEGER
		do
			event_type := c_gdk_event_type (eventp)
			inspect event_type 
			when Gdk_button_press then
				!GDK_BUTTON_EVENT!Result.make_from_pointer (eventp)
				-- TODO: Other events need to be added here
			else
				!!Result.make_from_pointer (eventp)
			end
		end

end -- GDK_EVENT_FACTORY
