-- Copyright (C) 1999 Dave E Martin XXIII and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing
	description: "Gtk Data"
	author: "Dave E Martin XXIII"
	genesis: "199905120612 utc"
	version: "v 0.3.3 GTK+ 1.2.x"
	gtk_version: "1.2"
	cvs: "$Id: gtk_adjustment.e,v 1.8 1999/10/03 02:07:18 richieb Exp $"

class GTK_ADJUSTMENT

--TODO clone/copy for this class must always be "deep"
--
-- Signals (from gtkadjustment.c):
--     "changed"        -
--     "value_changed"  -

inherit

	GTK_ADJUSTMENT_EXTERNALS
		undefine
			copy, is_equal
		end

	GTK_DATA
		rename
			data as adjustment
		end

creation

	make,
	make_from_pointer

feature {NONE} -- initialization

	make (the_value, the_lower, the_upper, the_step_increment,
		the_page_increment, the_page_size: REAL) is
		do
			adjustment := gtk_adjustment_new (the_value, the_lower,
				the_upper, the_step_increment, the_page_increment, the_page_size)
		end

feature -- query

	lower: REAL is
		do
			Result := c_gtk_adjustment_get_lower (adjustment)
		end

	upper: REAL is
		do
			Result := c_gtk_adjustment_get_upper (adjustment)
		end

	value: REAL is
		do
			Result := c_gtk_adjustment_get_value (adjustment)
		end

	step_increment: REAL is
		do
			Result := c_gtk_adjustment_get_step_increment (adjustment)
		end

	page_increment: REAL is
		do
			Result := c_gtk_adjustment_get_page_increment (adjustment)
		end

	page_size: REAL is
		do
			Result := c_gtk_adjustment_get_page_size (adjustment)
		end

feature -- commands

	changed is
			-- notify all associated widgets via "changed" gtk signal
		do
			gtk_adjustment_changed (adjustment)
		end

	value_changed is
			-- notify all associated widgets via "value changed" gtk signal
		do
			gtk_adjustment_value_changed (adjustment)
		end

	clamp_page (the_lower, the_upper: REAL) is
			-- TODO not sure how to explain what this does, but it changes
			-- the value.  see the C code in the gtk library.  emits a
			-- "value changed" if the value actually changes
		do
			gtk_adjustment_clamp_page (adjustment, the_lower, the_upper);
		end

feature -- setters

	set_lower (the_value: REAL) is
			-- invoke "changed" after you are done setting things
		do
			c_gtk_adjustment_set_lower (adjustment, the_value)
		end

	set_upper (the_value: REAL) is
			-- invoke "changed" after you are done setting things
		do
			c_gtk_adjustment_set_upper (adjustment, the_value)
		end

	set_value (the_value: REAL) is
			-- sets value, clamping it to the range specified by lower and upper
			-- automatically calls value_changed, if the value actually changed
		do
			gtk_adjustment_set_value (adjustment, the_value)
			-- the C code automatically calls value_changed, 
			-- if the value actually changed
		end

	set_step_increment (the_value: REAL) is
			-- invoke "changed" after you are done setting things
		do
			c_gtk_adjustment_set_step_increment (adjustment, the_value)
		end

	set_page_increment (the_value: REAL) is
			-- invoke "changed" after you are done setting things
		do
			c_gtk_adjustment_set_page_increment (adjustment, the_value)
		end

	set_page_size (the_value: REAL) is
			-- at time of writing, page_size is only used by scrollbar widgets
			-- and the highest value you get is actually upper - page_size.
			-- invoke "changed" after you are done setting things
		do
			c_gtk_adjustment_set_page_size (adjustment, the_value)
		end

	-- NOTE, by using various set operations, it is possible for value to become
	-- "illegal" temporarily (until it is changed again by set_value, or GUI
	-- action)

end --  GTK_ADJUSTMENT
