-- Copyright 1998 Richie Bielak and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Any widget that contains other widgets"
	version: "v 0.3.3 GTK+ 1.2.x"
	author: "Richie Bielak"
	changed: "11/10/98"
	cvs: "$Id: gtk_container.e,v 1.7 1999/10/03 02:07:19 richieb Exp $"

deferred class GTK_CONTAINER

-- A container widget into which one and only one other widget can be
-- placed. (Use GTK_BOX or GTK_TABLE if you want to hold multiple other
-- widgets.)
--
-- Signals (from gtkcontainer.c):
--    "add"              -
--    "check_resize"     -
--    "focus"            -
--    "remove"           -
--    "set-focus-child"  -

inherit

	GTK_WIDGET

	GTK_CONTAINER_EXTERNALS
		undefine
			copy, is_equal
		end

feature

	set_border_width (new_width: INTEGER) is
		require
			width_valid: new_width >= 0
		do
			gtk_container_set_border_width (widget, new_width)
		end
	
	remove_widget (child: GTK_WIDGET) is
		require
			child_not_void: child /= Void
			my_child: is_my_child (child)
			-- although the code would cope, violating this
			-- precondition would indicate a logic failure in
			-- the application code.
		deferred
		end

	add_widget (child: GTK_WIDGET) is
		require
			child_not_void: child /= Void
			no_parent: child.parent = Void
		deferred
		ensure
			my_child: child.parent = Current
		end

	is_my_child (a_widget: GTK_WIDGET): BOOLEAN is
		require
			child_not_void: a_widget /= Void
		do
			Result := (a_widget.parent = Current)
		ensure
			sane: Result implies a_widget.parent = Current
		end

	focus_child: GTK_WIDGET is
		local
			childp: POINTER
		do
			childp := c_focus_child (widget)
			if childp /= default_pointer then
				-- child exists in Gtk, see if it's also created in 
				-- Eiffel
				Result := child_by_pointer (childp)
				if Result = Void then
					!!Result.make_from_pointer (childp)
				end
			end
		end

feature {GTK_WIDGET}

	add_child (child: GTK_WIDGET) is
			-- this routine handles Eiffel attributes for setting
			-- up relationships between parents and children
		require
			good_child: child /= Void
		deferred
		ensure
			my_child: child.parent = Current
		end

	child_by_pointer (p: POINTER): GTK_WIDGET is
		require
			valid_pointer: p /= default_pointer
		deferred
		ensure
			really_mine: Result /= Void implies Result.parent = Current
		end

end
