/* ------------------------------
 * stat functions for the ZEUS
 * collaboration
 */

#ifdef HAVE_CONFIG_H
#   include <config.h>
#endif

#include <sys/types.h>  /* (see lstat.h), chb, Fri 01.08.1997 (12:09) */
#include <sys/stat.h>
#if 0 /* do we need this? */
#   include <unistd.h>
#endif

void
_reorder_stat2array( struct stat *stat, int sb[12])
{
  sb[0] = stat->st_dev;
  sb[1] = stat->st_ino;
  sb[2] = stat->st_mode;
  sb[3] = stat->st_nlink;
  sb[4] = stat->st_uid;
  sb[5] = stat->st_gid;
#if HAVE_ST_RDEV         /* autoconf seems to think this may be missing */
  sb[6] = stat->st_rdev;
#else
  sb[6] = 0;
#endif
  sb[7] = stat->st_size;
  sb[8] = stat->st_atime;
  sb[9] = stat->st_mtime;
  sb[10] = stat->st_ctime;
#if HAVE_ST_BLKSIZE      /* dito. */
  sb[11] = stat->st_blksize;
#else
  sb[11] = 0; /* XXX any better idea? - hope nobody uses this w/o thinking */
#endif
}
